/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.expr.StructMemberAccessExpression;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.types.Struct;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.kdtree.KdNode;
import org.locationtech.jts.index.kdtree.KdNodeVisitor;
import org.locationtech.jts.index.kdtree.KdTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NearestNeighbourIndex {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NearestNeighbourIndex.class);
    private final Envelope envelope = new Envelope();
    private final StructMemberAccessExpression geometryMemberAccessor;
    private final double startSize;
    private final double maxDistanceInCrsUnits;
    private final KdTree tree = new KdTree();
    private final int expectedSrid;

    public static NearestNeighbourIndex metricMaxDistance(Struct.StructMember geometryMember, SRIDSet sridSet, CoordinateReferenceSystem crs, double maxDistance) {
        int expectedSrid = sridSet.get(crs);
        double distanceInCrsUnits = GeometryUtils.toCrsUnits((double)maxDistance, (CoordinateReferenceSystem)crs);
        return new NearestNeighbourIndex(geometryMember, distanceInCrsUnits, expectedSrid);
    }

    private NearestNeighbourIndex(Struct.StructMember geometryMember, Double maxDistanceInCrsUnits, int expectedSrid) {
        this.expectedSrid = expectedSrid;
        this.geometryMemberAccessor = new StructMemberAccessExpression(false, geometryMember);
        this.maxDistanceInCrsUnits = maxDistanceInCrsUnits;
        this.startSize = maxDistanceInCrsUnits * 2.0;
    }

    public final void insert(Tuple item) {
        Geometry geom = this.geometryMemberAccessor.evaluate(item, Geometry.class);
        if (geom == null) {
            return;
        }
        if (geom.getSRID() != this.expectedSrid) {
            throw new AssertionError((Object)"NearestNeighbourIndex does not support mixed CRS - expected SRID %d, got %d".formatted(this.expectedSrid, geom.getSRID()));
        }
        this.tree.insert(geom.getCentroid().getCoordinate(), (Object)item);
        this.envelope.expandToInclude(geom.getEnvelopeInternal());
    }

    public Envelope getEnvelope() {
        return new Envelope(this.envelope.getMinX() - this.maxDistanceInCrsUnits, this.envelope.getMaxX() + this.maxDistanceInCrsUnits, this.envelope.getMinY() - this.maxDistanceInCrsUnits, this.envelope.getMaxY() + this.maxDistanceInCrsUnits);
    }

    public Tuple query(Coordinate coordinate) {
        if (this.tree.isEmpty()) {
            return null;
        }
        Envelope bounds = this.getEnvelope();
        double currentSize = this.startSize / 2.0;
        Visitor visitor = new Visitor(coordinate);
        Envelope initialEnv = new Envelope(coordinate);
        Envelope queryEnv = new Envelope(coordinate);
        int expansions = 0;
        while (!queryEnv.covers(bounds)) {
            queryEnv.init(initialEnv);
            queryEnv.expandBy(currentSize);
            visitor.currentDistance = currentSize;
            if (queryEnv.covers(bounds)) {
                visitor.ignoreRadiusCompensation = true;
            }
            this.tree.query(queryEnv, (KdNodeVisitor)visitor);
            if (visitor.closest != null) {
                Coordinate foundAt;
                if (visitor.visitCount > 100) {
                    log.info("Item found after {} visits, consider decreasing start bounds size ", (Object)visitor.visitCount);
                }
                if ((foundAt = visitor.closest.getCoordinate()).distance(coordinate) > this.maxDistanceInCrsUnits) break;
                return (Tuple)visitor.closest.getData();
            }
            if (currentSize > this.maxDistanceInCrsUnits) break;
            currentSize *= 2.0;
            if (++expansions <= 5) continue;
            log.warn("Nothing found within envelope after 5 expansions {}...", (Object)expansions);
        }
        return null;
    }

    @Generated
    public double getMaxDistanceInCrsUnits() {
        return this.maxDistanceInCrsUnits;
    }

    public static class Visitor
    implements KdNodeVisitor {
        public final Coordinate lookFor;
        public KdNode closest;
        public double lastDistance = 0.0;
        public double currentDistance = Double.POSITIVE_INFINITY;
        public int visitCount = 0;
        public boolean ignoreRadiusCompensation = false;

        public void visit(KdNode node) {
            double distance = node.getCoordinate().distance(this.lookFor);
            ++this.visitCount;
            if (distance > this.currentDistance && !this.ignoreRadiusCompensation) {
                return;
            }
            if (this.closest == null) {
                this.closest = node;
                this.lastDistance = distance;
            } else if (distance < this.lastDistance) {
                this.closest = node;
                this.lastDistance = distance;
            }
        }

        @Generated
        public Visitor(Coordinate lookFor) {
            this.lookFor = lookFor;
        }
    }
}

