/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.expr.StructMemberAccessExpression;
import nz.org.riskscape.engine.geo.GeometryFamily;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.geo.OverlayOperations;
import nz.org.riskscape.engine.geo.Quadrant;
import nz.org.riskscape.engine.geo.RecursiveQuadGridOp;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.StandardCodes;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.factory.epsg.CartesianAuthorityFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.strtree.STRtree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntersectionIndex {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntersectionIndex.class);
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);
    private final STRtree tree = new STRtree();
    private final Envelope envelope = new Envelope();
    private final StructMemberAccessExpression geometryMemberAccessor;
    private final SRIDSet sridSet;
    private final Options options;
    private final OverlayOperations overlayOperations = OverlayOperations.get();
    private CoordinateReferenceSystem crs = CartesianAuthorityFactory.GENERIC_2D;
    private int srid = -1;
    private GeometryFamily indexedFamily = GeometryFamily.PUNTAL;

    public static Options defaultOptions() {
        return new Options();
    }

    public static IntersectionIndex populateFromRelation(Relation rhsRelation, Type lhsGeomType, SRIDSet sridSet, Options options) throws ProblemException {
        Function<Object, Object> tupleMapper;
        Struct.StructMember geomMember;
        try {
            geomMember = TupleUtils.findGeometryMember((Struct)rhsRelation.getType(), (TupleUtils.FindOption)TupleUtils.FindOption.ANY_REQUIRED);
        }
        catch (RiskscapeException e) {
            throw new ProblemException((Problems)Problem.error((ProblemCode)StandardCodes.GEOMETRY_REQUIRED, (Object[])new Object[]{rhsRelation.getType()}));
        }
        IntersectionIndex index = new IntersectionIndex(geomMember, sridSet, options);
        Optional lhsReferencedGeomType = Nullable.strip((Type)lhsGeomType).find(Referenced.class);
        if (lhsReferencedGeomType.isPresent() && GeometryUtils.canReprojectSafely((Type)geomMember.getType(), (Type)lhsGeomType)) {
            int lhsSrid = sridSet.get(((Referenced)lhsReferencedGeomType.get()).getCrs());
            tupleMapper = t -> {
                Geometry geom = (Geometry)t.fetch(geomMember);
                t.set(geomMember, (Object)sridSet.reproject(geom, lhsSrid));
                return t;
            };
        } else {
            tupleMapper = Function.identity();
        }
        rhsRelation.iterator().forEachRemaining(tuple -> index.insert((Tuple)tupleMapper.apply(tuple)));
        index.build();
        return index;
    }

    public static IntersectionIndex withDefaultOptions(Struct.StructMember expression, SRIDSet sridSet) {
        return new IntersectionIndex(expression, sridSet, new Options());
    }

    public static IntersectionIndex withDefaultOptions(StructMemberAccessExpression expression, SRIDSet sridSet) {
        return new IntersectionIndex(expression, sridSet, new Options());
    }

    public IntersectionIndex(Struct.StructMember geometryMember, SRIDSet sridSet, Options options) {
        this.geometryMemberAccessor = new StructMemberAccessExpression(false, geometryMember);
        this.sridSet = sridSet;
        this.options = options;
    }

    public void build() {
        this.tree.build();
    }

    public void insert(Tuple tuple) {
        Geometry geom = this.geometryMemberAccessor.evaluate(tuple, Geometry.class);
        if (geom == null) {
            return;
        }
        if (this.srid == -1) {
            this.srid = geom.getSRID();
            this.crs = this.sridSet.get(this.srid);
            this.indexedFamily = GeometryFamily.fromClass(geom.getClass());
            if (this.options.cutBeforeAdding.isEmpty()) {
                boolean cutBeforeAdding = this.indexedFamily == GeometryFamily.POLYGONAL;
                log.debug("cutBeforeAdding default value is set to {}", (Object)cutBeforeAdding);
                this.options.cutBeforeAdding = Optional.of(cutBeforeAdding);
            }
            if (this.options.cutBeforeAdding.get().booleanValue() && this.indexedFamily != GeometryFamily.POLYGONAL) {
                throw new RiskscapeException((Problems)GeneralProblems.get().operationNotSupported("intersection index cutting + " + String.valueOf(this.indexedFamily), this.getClass()).withChildren(new Problems[]{PROBLEMS.intersectionCutNotSupportedHint(this.indexedFamily)}));
            }
        }
        Envelope geomEnvelope = geom.getEnvelopeInternal();
        if (this.options.cutBeforeAdding.get().booleanValue()) {
            if (!this.indexedFamily.isSameFamily(geom)) {
                GeometryFamily currentGeomFamily = GeometryFamily.fromClass(geom.getClass());
                throw new RiskscapeException((Problems)GeneralProblems.get().operationNotSupported("intersection index cutting + " + String.valueOf(currentGeomFamily), this.getClass()).withChildren(new Problems[]{PROBLEMS.intersectionCutNotSupportedHint(currentGeomFamily)}));
            }
            if (this.options.isTooComplex(geom, geomEnvelope)) {
                this.cutComplexGeometry(tuple, geom, geomEnvelope);
            } else {
                this.tree.insert(geomEnvelope, (Object)Pair.of((Object)tuple, (Object)geom));
            }
        } else {
            this.tree.insert(geomEnvelope, (Object)tuple);
        }
        this.envelope.expandToInclude(geomEnvelope);
    }

    private void cutComplexGeometry(Tuple tuple, Geometry geom, Envelope env) {
        LinkedList<Geometry> stack = new LinkedList<Geometry>();
        this.cutOnce(geom, env, stack);
        while (!stack.isEmpty()) {
            Envelope candidateEnv;
            Geometry candidate = stack.removeFirst();
            if (this.options.isTooComplex(candidate, candidateEnv = candidate.getEnvelopeInternal())) {
                this.cutOnce(candidate, candidateEnv, stack);
                continue;
            }
            this.tree.insert(candidateEnv, (Object)Pair.of((Object)tuple, (Object)candidate));
        }
    }

    private void cutOnce(Geometry geom, Envelope env, LinkedList<Geometry> stack) {
        Collection<Envelope> envelopes = Quadrant.partition(env).values();
        for (Envelope quadEnvelope : envelopes) {
            LinearRing envRing = RecursiveQuadGridOp.envelopeToRing(geom.getFactory(), quadEnvelope);
            Geometry intersection = geom.intersection((Geometry)new Polygon(envRing, null, envRing.getFactory()));
            if (intersection.isEmpty()) continue;
            stack.add(intersection);
        }
    }

    public ReferencedEnvelope getReferencedEnvelope() {
        return new ReferencedEnvelope(this.envelope.getMinX(), this.envelope.getMaxX(), this.envelope.getMinY(), this.envelope.getMaxY(), this.crs);
    }

    public List<Pair<Geometry, Tuple>> findIntersections(Geometry geom) {
        return this.findIntersections(geom, g -> {});
    }

    public Pair<Optional<Geometry>, List<Pair<Geometry, Tuple>>> findDifferenceAndIntersections(Geometry geom) {
        ArrayList unprojectedMatches = Lists.newArrayList();
        List<Pair<Geometry, Tuple>> intersections = this.findIntersections(geom, g -> unprojectedMatches.add(g));
        if (intersections.isEmpty()) {
            return Pair.of(Optional.of(geom), intersections);
        }
        Geometry reprojected = this.sridSet.reproject(geom, this.srid);
        Point combined = reprojected.getFactory().createPoint();
        for (Geometry unprojectedOverlap : unprojectedMatches) {
            combined = combined.union(unprojectedOverlap);
        }
        GeometryFamily reprojectedGeomFamily = GeometryFamily.from((Geometry)reprojected);
        Geometry remainder = GeometryUtils.removeNonFamilyMembers((Geometry)this.overlayOperations.difference(reprojected.copy(), (Geometry)combined), (GeometryFamily)reprojectedGeomFamily);
        if (remainder.isEmpty()) {
            return Pair.of(Optional.empty(), intersections);
        }
        return Pair.of(Optional.of(this.sridSet.reproject(remainder, geom.getSRID())), intersections);
    }

    private List<Pair<Geometry, Tuple>> findIntersections(Geometry geom, Consumer<Geometry> matchConsumer) {
        if (this.tree.isEmpty()) {
            return Collections.emptyList();
        }
        Geometry reprojected = this.sridSet.reproject(geom, this.srid);
        List<Tuple> found = this.options.cutBeforeAdding.get() != false ? this.tree.query(reprojected.getEnvelopeInternal()).stream().map(pair -> (Tuple)pair.getLeft()).distinct().toList() : this.tree.query(reprojected.getEnvelopeInternal());
        ArrayList<Pair<Geometry, Tuple>> intersecting = new ArrayList<Pair<Geometry, Tuple>>(found.size());
        GeometryFamily expectedType = GeometryFamily.fromClass(geom.getClass()).min(this.indexedFamily);
        for (Tuple t : found) {
            Geometry toMatch = this.geometryMemberAccessor.evaluate(t, Geometry.class);
            Geometry intersection = GeometryUtils.removeNonFamilyMembers((Geometry)this.overlayOperations.intersection(toMatch, reprojected), (GeometryFamily)expectedType);
            if (intersection.isEmpty()) continue;
            matchConsumer.accept(toMatch);
            if (geom.getSRID() != intersection.getSRID() && intersection.equalsTopo(reprojected)) {
                intersecting.add((Pair<Geometry, Tuple>)new Pair((Object)geom, (Object)t));
                continue;
            }
            intersecting.add((Pair<Geometry, Tuple>)new Pair((Object)this.sridSet.reproject(intersection, geom.getSRID()), (Object)t));
        }
        return intersecting;
    }

    public List<Tuple> findPointIntersections(Point point) {
        ArrayList<Tuple> intersections;
        if (this.tree.isEmpty()) {
            return Collections.emptyList();
        }
        Geometry reprojected = this.sridSet.reproject((Geometry)point, this.srid);
        if (this.options.cutBeforeAdding.get().booleanValue()) {
            List queried = this.tree.query(reprojected.getEnvelopeInternal());
            intersections = new ArrayList<Tuple>(queried.size());
            for (Pair pair : queried) {
                Geometry indexedGeom = (Geometry)pair.getRight();
                Tuple tuple = (Tuple)pair.getLeft();
                if (!indexedGeom.intersects(reprojected)) continue;
                intersections.add(tuple);
            }
        } else {
            List queried = this.tree.query(reprojected.getEnvelopeInternal());
            intersections = new ArrayList(queried.size());
            for (Tuple tuple : queried) {
                Geometry indexedGeom = (Geometry)this.geometryMemberAccessor.evaluate((Object)tuple);
                if (!indexedGeom.intersects(reprojected)) continue;
                intersections.add(tuple);
            }
        }
        return intersections;
    }

    int size() {
        return this.tree.size();
    }

    @Generated
    public IntersectionIndex(StructMemberAccessExpression geometryMemberAccessor, SRIDSet sridSet, Options options) {
        this.geometryMemberAccessor = geometryMemberAccessor;
        this.sridSet = sridSet;
        this.options = options;
    }

    public static class Options {
        private Optional<Boolean> cutBeforeAdding = Optional.of(false);
        private long cutPoints = 1000L;
        private long cutRatioPoints = 250L;
        private double cutRatio = 0.75;
        private long cutSizeMapUnits = -1L;

        public boolean isTooComplex(Geometry geom, Envelope geomEnvelope) {
            int numPoints = geom.getNumPoints();
            if (this.cutSizeMapUnits != -1L) {
                Polygon poly;
                if (geom instanceof Polygon && (poly = (Polygon)geom).getNumGeometries() == 1 && poly.getNumPoints() <= 5) {
                    return false;
                }
                double averageSize = (geomEnvelope.getWidth() + geomEnvelope.getHeight()) / 2.0;
                if (averageSize > (double)this.cutSizeMapUnits) {
                    return true;
                }
            }
            if ((long)numPoints > this.cutPoints) {
                return true;
            }
            return (long)numPoints > this.cutRatioPoints && geom.getArea() / geomEnvelope.getArea() < this.cutRatio;
        }

        @Generated
        public Options() {
        }

        @Generated
        public Optional<Boolean> getCutBeforeAdding() {
            return this.cutBeforeAdding;
        }

        @Generated
        public long getCutPoints() {
            return this.cutPoints;
        }

        @Generated
        public long getCutRatioPoints() {
            return this.cutRatioPoints;
        }

        @Generated
        public double getCutRatio() {
            return this.cutRatio;
        }

        @Generated
        public long getCutSizeMapUnits() {
            return this.cutSizeMapUnits;
        }

        @Generated
        public void setCutBeforeAdding(Optional<Boolean> cutBeforeAdding) {
            this.cutBeforeAdding = cutBeforeAdding;
        }

        @Generated
        public void setCutPoints(long cutPoints) {
            this.cutPoints = cutPoints;
        }

        @Generated
        public void setCutRatioPoints(long cutRatioPoints) {
            this.cutRatioPoints = cutRatioPoints;
        }

        @Generated
        public void setCutRatio(double cutRatio) {
            this.cutRatio = cutRatio;
        }

        @Generated
        public void setCutSizeMapUnits(long cutSizeMapUnits) {
            this.cutSizeMapUnits = cutSizeMapUnits;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCutPoints() != other.getCutPoints()) {
                return false;
            }
            if (this.getCutRatioPoints() != other.getCutRatioPoints()) {
                return false;
            }
            if (Double.compare(this.getCutRatio(), other.getCutRatio()) != 0) {
                return false;
            }
            if (this.getCutSizeMapUnits() != other.getCutSizeMapUnits()) {
                return false;
            }
            Optional<Boolean> this$cutBeforeAdding = this.getCutBeforeAdding();
            Optional<Boolean> other$cutBeforeAdding = other.getCutBeforeAdding();
            return !(this$cutBeforeAdding == null ? other$cutBeforeAdding != null : !((Object)this$cutBeforeAdding).equals(other$cutBeforeAdding));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $cutPoints = this.getCutPoints();
            result = result * 59 + (int)($cutPoints >>> 32 ^ $cutPoints);
            long $cutRatioPoints = this.getCutRatioPoints();
            result = result * 59 + (int)($cutRatioPoints >>> 32 ^ $cutRatioPoints);
            long $cutRatio = Double.doubleToLongBits(this.getCutRatio());
            result = result * 59 + (int)($cutRatio >>> 32 ^ $cutRatio);
            long $cutSizeMapUnits = this.getCutSizeMapUnits();
            result = result * 59 + (int)($cutSizeMapUnits >>> 32 ^ $cutSizeMapUnits);
            Optional<Boolean> $cutBeforeAdding = this.getCutBeforeAdding();
            result = result * 59 + ($cutBeforeAdding == null ? 43 : ((Object)$cutBeforeAdding).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IntersectionIndex.Options(cutBeforeAdding=" + String.valueOf(this.getCutBeforeAdding()) + ", cutPoints=" + this.getCutPoints() + ", cutRatioPoints=" + this.getCutRatioPoints() + ", cutRatio=" + this.getCutRatio() + ", cutSizeMapUnits=" + this.getCutSizeMapUnits() + ")";
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem intersectionCutNotSupportedHint(GeometryFamily var1);
    }
}

