/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import java.text.DecimalFormat;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;

public class GeometryRenderer {
    public static String getAxisOrder(CoordinateReferenceSystem crs) {
        ImmutableMap axisOrderNames = ImmutableMap.of((Object)CRS.AxisOrder.EAST_NORTH, (Object)"long,lat / X,Y / Easting,Northing", (Object)CRS.AxisOrder.NORTH_EAST, (Object)"lat,long / Y,X / Northing,Easting", (Object)CRS.AxisOrder.INAPPLICABLE, (Object)"N/A");
        return (String)axisOrderNames.get((Object)CRS.getAxisOrder((CoordinateReferenceSystem)crs));
    }

    public static String getCode(CoordinateReferenceSystem crs) {
        try {
            Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
            if (code != null) {
                return "EPSG:" + code.toString();
            }
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        return crs.getName().toString();
    }

    public static String getAxisDirection(CoordinateReferenceSystem crs, int dimension) {
        AxisDirection direction = crs.getCoordinateSystem().getAxis(dimension).getDirection();
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, direction.identifier());
    }

    public static String getBounds(ReferencedEnvelope env) {
        DecimalFormat df = new DecimalFormat("#.0###");
        CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
        return String.format("%s [%s : %s %s, %s : %s %s]", GeometryRenderer.getCode(crs), df.format(env.getMinX()), df.format(env.getMaxX()), GeometryRenderer.getAxisDirection(crs, 0), df.format(env.getMinY()), df.format(env.getMaxY()), GeometryRenderer.getAxisDirection(crs, 1));
    }

    public static String getBoundsInCrs(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCrs) {
        ReferencedEnvelope transformedBounds = null;
        try {
            transformedBounds = envelope.transform(targetCrs, true);
        }
        catch (Exception ex) {
            throw new RiskscapeException((Problems)((Errors)Problems.get(Errors.class)).cannotDisplay(envelope, GeometryRenderer.getCode(targetCrs)).withChildren(new Problems[]{Problems.caught((Throwable)ex)}));
        }
        return GeometryRenderer.getBounds(transformedBounds);
    }

    public static boolean isCrsEquivalent(CoordinateReferenceSystem a, CoordinateReferenceSystem b) {
        if (GeometryRenderer.getCode(a).equals(GeometryRenderer.getCode(b))) {
            return true;
        }
        return CRS.equalsIgnoreMetadata((Object)a, (Object)b);
    }

    private static interface Errors
    extends ProblemFactory {
        public Problem cannotDisplay(ReferencedEnvelope var1, String var2);
    }
}

