/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import java.util.stream.Collectors;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.geo.ProjectGeometryOp;
import org.locationtech.jts.geom.Geometry;

public class GeometryLengthOp {
    private final SRIDSet sridSet;
    private final ProjectGeometryOp projectionOp;

    public GeometryLengthOp(SRIDSet sridSet) {
        this(sridSet, new ProjectGeometryOp(sridSet));
    }

    public double apply(Geometry geometry, Unit<Length> targetUnit) {
        return this.projectionOp.apply(geometry).stream().collect(Collectors.summingDouble(projected -> {
            Unit sourceUnit = projected.getProjectedCrs().getCoordinateSystem().getAxis(0).getUnit().asType(Length.class);
            if (sourceUnit.equals(targetUnit)) {
                return projected.getProjected().getLength();
            }
            UnitConverter converter = sourceUnit.getConverterTo(targetUnit);
            return converter.convert(projected.getProjected().getLength());
        }));
    }

    @Generated
    public GeometryLengthOp(SRIDSet sridSet, ProjectGeometryOp projectionOp) {
        this.sridSet = sridSet;
        this.projectionOp = projectionOp;
    }
}

