/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import java.util.stream.Collectors;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Area;
import javax.measure.quantity.Length;
import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.geo.ProjectGeometryOp;
import org.locationtech.jts.geom.Geometry;

public class GeometryAreaOp {
    private final SRIDSet sridSet;
    private final ProjectGeometryOp projectionOp;

    public GeometryAreaOp(SRIDSet sridSet) {
        this(sridSet, new ProjectGeometryOp(sridSet));
    }

    public double apply(Geometry geometry, Unit<Area> targetUnit) {
        return this.projectionOp.apply(geometry).stream().collect(Collectors.summingDouble(projected -> {
            Unit baseUnit = projected.getProjectedCrs().getCoordinateSystem().getAxis(0).getUnit().asType(Length.class);
            Unit sourceUnit = baseUnit.multiply(baseUnit).asType(Area.class);
            if (sourceUnit.equals(targetUnit)) {
                return projected.getProjected().getArea();
            }
            UnitConverter converter = sourceUnit.getConverterTo(targetUnit);
            return converter.convert(projected.getProjected().getArea());
        }));
    }

    @Generated
    public GeometryAreaOp(SRIDSet sridSet, ProjectGeometryOp projectionOp) {
        this.sridSet = sridSet;
        this.projectionOp = projectionOp;
    }
}

