/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.geo;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import lombok.Generated;
import nz.org.riskscape.engine.util.SegmentedList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

class BlockBasedSquareList
extends AbstractList<Polygon> {
    private final GeometryFactory factory;
    private final double squareSize;
    private final List<Envelope> blocks = SegmentedList.forClass(Envelope.class);
    private int totalSegments = 0;

    void addBlock(Envelope envelope) {
        assert (this.isBlockSizeRoughlyValid(envelope));
        this.blocks.add(envelope);
        this.totalSegments += this.segmentsPerSide(envelope) * this.segmentsPerSide(envelope);
    }

    @Override
    public Polygon get(int index) {
        int idx = 0;
        Iterator<Polygon> iter = this.iterator();
        while (index > idx++) {
            iter.next();
        }
        return iter.next();
    }

    @Override
    public Iterator<Polygon> iterator() {
        final Iterator<Envelope> envIter = this.blocks.iterator();
        return new Iterator<Polygon>(){
            int curSize = 0;
            int pos = 0;
            Envelope curEnv;
            int segmentsInCurEnv = 0;

            @Override
            public boolean hasNext() {
                if (this.segmentsInCurEnv == this.pos) {
                    if (envIter.hasNext()) {
                        this.curEnv = (Envelope)envIter.next();
                        this.pos = 0;
                        this.curSize = BlockBasedSquareList.this.segmentsPerSide(this.curEnv);
                        this.segmentsInCurEnv = this.curSize * this.curSize;
                    } else {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Polygon next() {
                if (this.segmentsInCurEnv == this.pos && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                double originx = this.curEnv.getMinX();
                double originy = this.curEnv.getMinY();
                int xpos = this.pos % this.curSize;
                int ypos = this.pos == 0 ? 0 : (this.pos - xpos) / this.curSize;
                double minx = originx + (double)xpos * BlockBasedSquareList.this.squareSize;
                double miny = originy + (double)ypos * BlockBasedSquareList.this.squareSize;
                double maxx = minx + BlockBasedSquareList.this.squareSize;
                double maxy = miny + BlockBasedSquareList.this.squareSize;
                LinearRing ring = new LinearRing((CoordinateSequence)new PackedCoordinateSequence.Double(new double[]{minx, miny, minx, maxy, maxx, maxy, maxx, miny, minx, miny}, 2, 0), BlockBasedSquareList.this.factory);
                ++this.pos;
                return new Polygon(ring, null, BlockBasedSquareList.this.factory);
            }
        };
    }

    @Override
    public int size() {
        return this.totalSegments;
    }

    private int segmentsPerSide(Envelope envelope) {
        return (int)Math.round(envelope.getWidth() / this.squareSize);
    }

    private boolean isBlockSizeRoughlyValid(Envelope envelope) {
        boolean isSquare = Math.abs(envelope.getWidth() - envelope.getHeight()) < 1.0;
        double expectedSize = this.squareSize * (double)this.segmentsPerSide(envelope);
        boolean isExpectedSize = Math.abs(envelope.getWidth() - expectedSize) < 1.0;
        return isSquare && isExpectedSize;
    }

    @Generated
    public BlockBasedSquareList(GeometryFactory factory, double squareSize) {
        this.factory = factory;
        this.squareSize = squareSize;
    }

    @Generated
    public List<Envelope> getBlocks() {
        return this.blocks;
    }
}

