/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.maths;

import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseMathsFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class Scale
extends BaseMathsFunction
implements IdentifiedFunction,
RealizableFunction {
    private final ArgumentList arguments = ArgumentList.create((String)"input_value", (Type)Types.ANYTHING, (String)"scale_factor", (Type)Types.FLOATING);
    private final List<Type> argumentTypes = this.getTypesFromArguments();
    private final Type returnType = Types.ANYTHING;

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argTypes) {
        Type toScaleType = argTypes.get(0);
        Type scaleFactorType = argTypes.get(1);
        if (!scaleFactorType.equals(Types.FLOATING)) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.mismatch((FunctionArgument)this.getArguments().get(1), (Type)scaleFactorType)});
        }
        if (toScaleType.isNumeric()) {
            return ResultOrProblems.of((Object)new ScaleImpl(argTypes, (Type)Types.FLOATING, (x, scaleFactor) -> this.scaleNumber((Number)x, (double)scaleFactor)));
        }
        Optional scaler = toScaleType.find(Struct.class).flatMap(struct -> {
            Struct resultStruct = struct;
            List numericMembers = struct.getMembers().stream().filter(member -> Nullable.strip((Type)member.getType()).isNumeric()).collect(Collectors.toList());
            if (numericMembers.isEmpty()) {
                return Optional.empty();
            }
            for (Struct.StructMember member2 : numericMembers) {
                boolean nullableMember = Nullable.is((Type)member2.getType());
                resultStruct = resultStruct.addOrReplace(member2.getKey(), Nullable.ifTrue((boolean)nullableMember, (Type)Types.FLOATING));
            }
            Struct resultType = resultStruct;
            BiFunction<Object, Double, Object> structScaler = (x, scaleFactor) -> {
                Tuple input = (Tuple)x;
                Object[] argsArray = input.toArray();
                for (Struct.StructMember member : numericMembers) {
                    argsArray[member.getIndex()] = this.scaleNumber((Number)argsArray[member.getIndex()], (double)scaleFactor);
                }
                return Tuple.ofValues((Struct)resultType, (Object[])argsArray);
            };
            return Optional.of(new ScaleImpl(argTypes, (Type)resultType, structScaler));
        });
        if (scaler.isPresent()) {
            return ResultOrProblems.of((Object)((RiskscapeFunction)scaler.get()));
        }
        return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().notNumeric(this.getArguments().get(0), toScaleType)});
    }

    private Double scaleNumber(Number toScale, double scaleFactor) {
        if (toScale == null) {
            return null;
        }
        return toScale.doubleValue() * scaleFactor;
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }

    private static class ScaleImpl
    implements RiskscapeFunction {
        private final List<Type> argumentTypes;
        private final Type returnType;
        private final BiFunction<Object, Double, Object> scaleFunction;

        public Object call(List<Object> args) {
            Double scaleFactor = (Double)args.get(1);
            return this.scaleFunction.apply(args.get(0), scaleFactor);
        }

        @Generated
        public ScaleImpl(List<Type> argumentTypes, Type returnType, BiFunction<Object, Double, Object> scaleFunction) {
            this.argumentTypes = argumentTypes;
            this.returnType = returnType;
            this.scaleFunction = scaleFunction;
        }

        @Generated
        public List<Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        @Generated
        public Type getReturnType() {
            return this.returnType;
        }
    }
}

