/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.maths;

import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Floating;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.RandomUtils;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.rl.ast.FunctionCall;

public class RandomNorm
extends BaseRealizableFunction {
    public RandomNorm() {
        super(ArgumentList.create((String)"mean", (Type)Types.FLOATING, (String)"stddev", (Type)Types.FLOATING, (String)"seed", (Type)Nullable.INTEGER, (String)"samples", (Type)Nullable.INTEGER), (Type)Types.FLOATING);
    }

    @Override
    public RiskscapeFunction build(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) throws ProblemException {
        boolean hasMultipleSamples = this.arguments.getArgument(functionCall, "samples").isPresent();
        boolean hasSeed = this.arguments.getArgument(functionCall, "seed").isPresent();
        Floating returnType = Types.FLOATING;
        Long samples = 1L;
        if (hasMultipleSamples) {
            samples = (Long)this.arguments.get("samples").evaluateConstant(context, functionCall, Long.class).getOrThrow();
            returnType = RSList.create((Type)Types.FLOATING);
        }
        int numSamples = samples.intValue();
        return RiskscapeFunction.create((Object)this, givenTypes, (Type)returnType, args -> {
            Optional<Object> seed = Optional.ofNullable(hasSeed ? (Long)args.get(2) : null);
            List sampled = RandomUtils.getNormalVariate((double)((Double)args.get(0)), (double)((Double)args.get(1)), seed, (int)numSamples);
            return hasMultipleSamples ? sampled : sampled.get(0);
        }, (AutoCloseable[])new AutoCloseable[0]);
    }
}

