/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.maths;

import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.RandomUtils;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.rl.ast.FunctionCall;

public class RandomChoice
extends BaseRealizableFunction {
    public RandomChoice() {
        super(ArgumentList.create((String)"items", (Type)RSList.LIST_ANYTHING, (String)"weights", (Type)Nullable.of((Type)RSList.create((Type)Types.FLOATING)), (String)"seed", (Type)Nullable.INTEGER), (Type)Nullable.ANYTHING);
    }

    @Override
    public RiskscapeFunction build(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) throws ProblemException {
        RSList items = (RSList)this.arguments.getRequiredAs(givenTypes, 0, RSList.class).getOrThrow();
        boolean hasWeights = this.arguments.getArgument(functionCall, "weights").isPresent();
        boolean hasSeed = this.arguments.getArgument(functionCall, "seed").isPresent();
        return RiskscapeFunction.create((Object)this, givenTypes, (Type)items.getContainedType(), args -> {
            List from = (List)args.get(0);
            Optional<Object> seed = Optional.ofNullable(hasSeed ? (Long)args.get(2) : null);
            if (hasWeights) {
                List weights = (List)args.get(1);
                return RandomUtils.pick((List)from, (List)weights, seed);
            }
            return RandomUtils.pick((List)from, seed);
        }, (AutoCloseable[])new AutoCloseable[0]);
    }
}

