/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.maths;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseMathsFunction;
import nz.org.riskscape.engine.function.OverloadedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

public class Pow
extends BaseMathsFunction
implements OverloadedFunction {
    private final ArgumentList arguments = ArgumentList.create((String)"x", (Type)Types.FLOATING, (String)"exp", (Type)Types.FLOATING);
    private final List<Type> argumentTypes = this.getTypesFromArguments();
    private final Type returnType = Types.FLOATING;

    public Pow() {
        this.description = "Raise a number by a specific power";
    }

    @Override
    public Object call(List<Object> args) {
        Number base = (Number)args.get(0);
        Number exp = (Number)args.get(1);
        return Math.pow(base.doubleValue(), exp.doubleValue());
    }

    public List<RiskscapeFunction> getAlternatives() {
        return Arrays.asList(this.wrapping(new Type[]{Types.FLOATING, Types.FLOATING}), this.wrapping(new Type[]{Types.FLOATING, Types.INTEGER}), this.wrapping(new Type[]{Types.INTEGER, Types.FLOATING}), this.wrapping(new Type[]{Types.INTEGER, Types.INTEGER}));
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }
}

