/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.maths;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.function.BaseMathsFunction;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizableFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public abstract class OverloadedAggregatingMathsFunction
extends BaseMathsFunction
implements RealizableFunction {
    private final Optional<AggregationFunction> aggregationFunction;
    private final RealizableFunction relizableAggFunction;

    public OverloadedAggregatingMathsFunction(AggregationFunction aggFunction) {
        this.aggregationFunction = Optional.of(aggFunction);
        RiskscapeFunction adapted = AggregationFunction.asFunction((AggregationFunction)aggFunction);
        if (!(adapted instanceof RealizableFunction)) {
            throw new RiskscapeException("Underlying aggregation function is not realizable");
        }
        this.relizableAggFunction = (RealizableFunction)adapted;
    }

    protected abstract List<RiskscapeFunction> getAlternatives();

    public List<Type> getArgumentTypes() {
        return Arrays.asList(Types.ANYTHING, Types.ANYTHING);
    }

    public Type getReturnType() {
        return Types.ANYTHING;
    }

    private boolean doArgumentsMatch(List<Type> givenTypes, List<Type> overloadedTypes, RealizationContext context) {
        for (int i = 0; i < givenTypes.size(); ++i) {
            if (context.getProject().getTypeSet().isAssignable(givenTypes.get(i), overloadedTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        if (givenTypes.size() == 1 && givenTypes.get(0).find(RSList.class).isPresent()) {
            return this.relizableAggFunction.realize(context, functionCall, givenTypes);
        }
        if (givenTypes.size() != 2) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(2, givenTypes.size())});
        }
        for (RiskscapeFunction alternative : this.getAlternatives()) {
            if (!this.doArgumentsMatch(givenTypes, alternative.getArgumentTypes(), context)) continue;
            return ResultOrProblems.of((Object)alternative);
        }
        return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().realizableDidNotMatch((IdentifiedFunction)this, givenTypes)});
    }

    @Generated
    public Optional<AggregationFunction> getAggregationFunction() {
        return this.aggregationFunction;
    }
}

