/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.maths;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.function.BaseMathsFunction;
import nz.org.riskscape.engine.function.OverloadedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UnaryFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

public class Log10
extends BaseMathsFunction
implements OverloadedFunction {
    public static final RiskscapeFunction DOUBLE_IMPL = new UnaryFunction((Type)Types.FLOATING, (Type)Types.FLOATING, d -> Math.log10(d));
    public static final RiskscapeFunction LONG_IMPL = new UnaryFunction((Type)Types.INTEGER, (Type)Types.FLOATING, i -> Math.log10(i.longValue()));
    private final List<RiskscapeFunction> alternatives = Arrays.asList(DOUBLE_IMPL, LONG_IMPL);
    private final List<Type> argumentTypes = Arrays.asList(Types.FLOATING);
    private final Type returnType = Types.FLOATING;

    public Log10() {
        this.description = "Returns the base-10 logarithm of the given value";
    }

    @Generated
    public List<RiskscapeFunction> getAlternatives() {
        return this.alternatives;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }
}

