/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.maths;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseMathsFunction;
import nz.org.riskscape.engine.function.OverloadedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

public class Log
extends BaseMathsFunction
implements OverloadedFunction {
    private final ArgumentList arguments = ArgumentList.create((String)"x", (Type)Types.FLOATING, (String)"base", (Type)Types.FLOATING);
    private final List<Type> argumentTypes = this.getTypesFromArguments();
    private final Type returnType = Types.FLOATING;

    public Log() {
        this.description = "Return the logarithm of a number for a particular base, defaulting to natural log if none given";
    }

    @Override
    public Object call(List<Object> args) {
        Number x = (Number)args.get(0);
        double result = Math.log(x.doubleValue());
        Number base = (Number)(args.size() > 1 ? args.get(1) : null);
        if (base == null) {
            return result;
        }
        return result / Math.log(base.doubleValue());
    }

    public List<RiskscapeFunction> getAlternatives() {
        return Arrays.asList(this.wrapping(new Type[]{Types.INTEGER, Types.INTEGER}), this.wrapping(new Type[]{Types.INTEGER, Types.FLOATING}), this.wrapping(new Type[]{Types.FLOATING, Types.INTEGER}), this.wrapping(new Type[]{Types.FLOATING, Types.FLOATING}), this.wrapping(new Type[]{Types.INTEGER}), this.wrapping(new Type[]{Types.FLOATING}));
    }

    @Generated
    public ArgumentList getArguments() {
        return this.arguments;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }
}

