/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.lang;

import java.util.ArrayList;
import java.util.List;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.ScopedLambdaType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class ZipLists
extends BaseRealizableFunction {
    public ZipLists() {
        super(ArgumentList.create((String)"lhs", (Type)RSList.create((Type)Nullable.ANYTHING), (String)"rhs", (Type)RSList.create((Type)Nullable.ANYTHING), (String)"lambda", (Type)new LambdaType(new String[]{"lhs_element", "rhs_element"})), (Type)RSList.LIST_ANYTHING);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenArgumentTypes) {
        ScopedLambdaType lambdaType;
        RSList list2Type;
        if (this.arguments.size() != givenArgumentTypes.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{((ArgsProblems)Problems.get(ArgsProblems.class)).wrongNumber(this.arguments.size(), givenArgumentTypes.size())});
        }
        ArrayList<Problem> realizationProblems = new ArrayList<Problem>();
        RSList list1Type = givenArgumentTypes.get(0).find(RSList.class).orElse(null);
        if (list1Type == null) {
            realizationProblems.add(ArgsProblems.mismatch((FunctionArgument)this.getArguments().get(0), (Type)givenArgumentTypes.get(0)));
        }
        if ((list2Type = (RSList)givenArgumentTypes.get(1).find(RSList.class).orElse(null)) == null) {
            realizationProblems.add(ArgsProblems.mismatch((FunctionArgument)this.getArguments().get(1), (Type)givenArgumentTypes.get(1)));
        }
        if ((lambdaType = (ScopedLambdaType)givenArgumentTypes.get(2).find(ScopedLambdaType.class).orElse(null)) == null) {
            realizationProblems.add(ArgsProblems.mismatch((FunctionArgument)this.getArguments().get(2), (Type)givenArgumentTypes.get(2)));
        } else if (lambdaType.getArity() != 2) {
            realizationProblems.add(ExpressionProblems.get().lambdaArityError(((FunctionCall.Argument)functionCall.getArguments().get(2)).getExpression(), lambdaType.getArity(), 2));
        }
        if (!realizationProblems.isEmpty()) {
            return ResultOrProblems.failed(realizationProblems);
        }
        Lambda lambda = (Lambda)((FunctionCall.Argument)functionCall.getArguments().get(2)).getExpression();
        String list1ElementArgName = ((Token)lambda.getArguments().get(0)).getValue();
        String list2ElementArgName = ((Token)lambda.getArguments().get(1)).getValue();
        Struct lambdaScopeType = lambdaType.buildCallingScopeType(new Type[]{list1Type.getMemberType(), list2Type.getMemberType()});
        ResultOrProblems realizedLambdaOr = context.getExpressionRealizer().realize((Type)lambdaScopeType, lambda.getExpression());
        if (realizedLambdaOr.hasErrors()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ExpressionProblems.get().failedToRealize(lambda.getExpression(), (Type)lambdaScopeType).withChildren(realizedLambdaOr.getProblems())});
        }
        RealizedExpression realized = (RealizedExpression)realizedLambdaOr.get();
        RSList newListType = RSList.create((Type)realized.getResultType());
        return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)this, givenArgumentTypes, (Type)newListType, args -> {
            ScopedLambdaExpression givenLambda = (ScopedLambdaExpression)args.get(2);
            List list1 = (List)args.get(0);
            List list2 = (List)args.get(1);
            ArrayList<Object> newList = new ArrayList<Object>(list1.size());
            for (int i = 0; i < list1.size() && i < list2.size(); ++i) {
                Tuple lambdaScope = givenLambda.buildCallingScope(lambdaScopeType, new Object[0]);
                Struct.StructMember list1ElementDestMember = lambdaScopeType.getEntry(list1ElementArgName);
                Struct.StructMember list2ElementDestMember = lambdaScopeType.getEntry(list2ElementArgName);
                lambdaScope.set(list1ElementDestMember, list1.get(i));
                lambdaScope.set(list2ElementDestMember, list2.get(i));
                newList.add(realized.evaluate((Object)lambdaScope));
            }
            return newList;
        }, (AutoCloseable[])new AutoCloseable[]{realized}));
    }
}

