/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.lang;

import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class RemoveAttr
extends BaseRealizableFunction {
    public RemoveAttr() {
        super(ArgumentList.create((String)"original", (Type)Types.ANYTHING, (String)"remove", (Type)Types.ANYTHING), (Type)Struct.EMPTY_STRUCT);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        return ProblemException.catching(() -> {
            List<String> toRemove;
            if (givenTypes.size() != this.arguments.size()) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(this.arguments.size(), givenTypes.size()));
            }
            Struct original = (Struct)this.arguments.getRequiredAs(givenTypes, 0, Struct.class).getOrThrow();
            ResultOrProblems text = ((FunctionCall.Argument)functionCall.getArguments().get(1)).evaluateConstant(context, String.class, (Type)Types.TEXT);
            if (text.isPresent()) {
                toRemove = List.of((String)text.get());
            } else {
                Struct struct = (Struct)this.arguments.getRequiredAs(givenTypes, 1, Struct.class).getOrThrow();
                toRemove = struct.getMembers().stream().map(Struct.StructMember::getKey).toList();
            }
            Struct output = (Struct)original.remove(toRemove).getOrThrow();
            List<Struct.StructMember> toInclude = original.getMembers().stream().filter(member -> !toRemove.contains(member.getKey())).toList();
            return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)output, args -> {
                Tuple originalTuple = (Tuple)args.get(0);
                Tuple outputTuple = new Tuple(output);
                for (int i = 0; i < toInclude.size(); ++i) {
                    Struct.StructMember attr = (Struct.StructMember)toInclude.get(i);
                    outputTuple.set(i, originalTuple.fetch(attr));
                }
                return outputTuple;
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }
}

