/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.lang;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class MergeStruct
extends BaseRealizableFunction {
    public MergeStruct() {
        super(ArgumentList.create((String)"original", (Type)Types.ANYTHING, (String)"replace", (Type)Types.ANYTHING), (Type)Struct.EMPTY_STRUCT);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        if (givenTypes.size() != 2) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(2, givenTypes.size())});
        }
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Struct original = this.getStruct(problems, functionCall, givenTypes, 0);
        Struct replace = this.getStruct(problems, functionCall, givenTypes, 1);
        if (Problem.hasErrors(problems)) {
            return ResultOrProblems.failed(problems);
        }
        Struct.StructBuilder builder = new Struct.StructBuilder();
        IndexInfo[] indices = this.setupLoop(builder, original, replace);
        Struct builtType = context.normalizeStruct(builder.build());
        return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)this, givenTypes, (Type)builtType, args -> {
            Tuple originalTuple = (Tuple)args.get(0);
            Tuple replaceTuple = (Tuple)args.get(1);
            Tuple mergedTuple = new Tuple(builtType);
            int index = 0;
            for (IndexInfo indexInfo : indices) {
                Object assign = (indexInfo.fromReplace ? replaceTuple : originalTuple).fetch(indexInfo.index);
                mergedTuple.set(index++, assign);
            }
            return mergedTuple;
        }, (AutoCloseable[])new AutoCloseable[0]));
    }

    private IndexInfo[] setupLoop(Struct.StructBuilder builder, Struct original, Struct replace) {
        LinkedHashMap<String, Struct.StructMember> replaceMembers = new LinkedHashMap<String, Struct.StructMember>();
        for (Struct.StructMember member : replace.getMembers()) {
            replaceMembers.put(member.getKey(), member);
        }
        ArrayList<IndexInfo> replacements = new ArrayList<IndexInfo>();
        for (Struct.StructMember structMember : original.getMembers()) {
            Struct.StructMember replaceMember = (Struct.StructMember)replaceMembers.remove(structMember.getKey());
            boolean fromReplace = replaceMember != null;
            Struct.StructMember member = fromReplace ? replaceMember : structMember;
            replacements.add(new IndexInfo(fromReplace, member.getIndex()));
            builder.add(member.getKey(), member.getType());
        }
        for (Map.Entry entry : replaceMembers.entrySet()) {
            Struct.StructMember append = (Struct.StructMember)entry.getValue();
            replacements.add(new IndexInfo(true, append.getIndex()));
            builder.add(append.getKey(), append.getType());
        }
        return replacements.toArray(new IndexInfo[replacements.size()]);
    }

    private Struct getStruct(List<Problem> problems, FunctionCall functionCall, List<Type> givenTypes, int i) {
        Optional structOr = givenTypes.get(i).find(Struct.class);
        if (!structOr.isPresent()) {
            problems.add(TypeProblems.get().mismatch((Object)((FunctionCall.Argument)functionCall.getArguments().get(i)).getExpression(), (Type)Struct.EMPTY_STRUCT, givenTypes.get(i)));
        }
        return structOr.orElse(null);
    }

    private class IndexInfo {
        final boolean fromReplace;
        final int index;

        @Generated
        public IndexInfo(boolean fromReplace, int index) {
            this.fromReplace = fromReplace;
            this.index = index;
        }
    }
}

