/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.lang;

import java.util.ArrayList;
import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.ScopedLambdaExpression;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.ScopedLambdaType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class MapList
extends BaseRealizableFunction {
    public MapList() {
        super(ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("iterable", (Type)RSList.create((Type)Nullable.ANYTHING)), new FunctionArgument("foreach", (Type)new LambdaType(new String[]{"list_element"}))}), (Type)RSList.LIST_ANYTHING);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenArgumentTypes) {
        if (this.arguments.size() != givenArgumentTypes.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{((ArgsProblems)Problems.get(ArgsProblems.class)).wrongNumber(this.arguments.size(), givenArgumentTypes.size())});
        }
        boolean nullableList = Nullable.is((Type)givenArgumentTypes.get(0));
        Type memberType = givenArgumentTypes.get(0).findAllowNull(RSList.class).map(a -> a.getMemberType()).orElse(givenArgumentTypes.get(0));
        ScopedLambdaType lambdaType = givenArgumentTypes.get(1).find(ScopedLambdaType.class).orElse(null);
        if (lambdaType == null) {
            return ResultOrProblems.failed((Problem[])new Problem[]{((TypeProblems)Problems.get(TypeProblems.class)).mismatch(functionCall.getArguments().get(1), this.arguments.get(1).getType(), givenArgumentTypes.get(1))});
        }
        if (lambdaType.getArity() != 1) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ExpressionProblems.get().lambdaArityError(((FunctionCall.Argument)functionCall.getArguments().get(1)).getExpression(), lambdaType.getArity(), 1)});
        }
        Lambda lambda = (Lambda)((FunctionCall.Argument)functionCall.getArguments().get(1)).getExpression();
        Struct lambdaScopeType = lambdaType.buildCallingScopeType(new Type[]{memberType});
        ResultOrProblems realizedLambdaOr = context.getExpressionRealizer().realize((Type)lambdaScopeType, lambda.getExpression());
        if (realizedLambdaOr.hasErrors()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ExpressionProblems.get().failedToRealize(lambda.getExpression(), (Type)lambdaScopeType).withChildren(realizedLambdaOr.getProblems())});
        }
        RealizedExpression realized = (RealizedExpression)realizedLambdaOr.get();
        if (memberType == givenArgumentTypes.get(0)) {
            return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)this, givenArgumentTypes, (Type)realized.getResultType(), args -> {
                ScopedLambdaExpression givenLambda = (ScopedLambdaExpression)args.get(1);
                Tuple lambdaScope = givenLambda.buildCallingScope(lambdaScopeType, args.get(0));
                return realized.evaluate((Object)lambdaScope);
            }, (AutoCloseable[])new AutoCloseable[0]));
        }
        Type newListType = Nullable.ifTrue((boolean)nullableList, (Type)RSList.create((Type)realized.getResultType()));
        return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)this, givenArgumentTypes, (Type)newListType, args -> {
            List list = (List)args.get(0);
            if (list == null) {
                return null;
            }
            ScopedLambdaExpression givenLambda = (ScopedLambdaExpression)args.get(1);
            ArrayList<Object> newList = new ArrayList<Object>(list.size());
            for (Object object : list) {
                Tuple lambdaScope = givenLambda.buildCallingScope(lambdaScopeType, new Object[0]);
                Struct.StructMember listElementDestMember = lambdaScopeType.getEntry((String)lambdaType.getArgs().get(0));
                lambdaScope.set(listElementDestMember, object);
                newList.add(realized.evaluate((Object)lambdaScope));
            }
            return newList;
        }, (AutoCloseable[])new AutoCloseable[]{realized}));
    }
}

