/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.lang;

import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;

public class IfNull
extends BaseRealizableFunction {
    public IfNull() {
        super(ArgumentList.create((String)"test", (Type)Nullable.ANYTHING, (String)"else", (Type)Nullable.ANYTHING), (Type)Types.ANYTHING);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        Type realizedReturnType;
        if (givenTypes.size() != this.arguments.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(this.arguments.size(), givenTypes.size())});
        }
        Type testType = Nullable.strip((Type)givenTypes.get(0));
        Type elseType = givenTypes.get(1);
        if (elseType.isNullable()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{TypeProblems.get().cannotBeNull((Object)this.arguments.get(1), testType, elseType)});
        }
        if (testType == Types.NOTHING || context.getProject().getTypeSet().isAssignable(testType, elseType)) {
            realizedReturnType = elseType;
        } else if (context.getProject().getTypeSet().isAssignable(elseType, testType)) {
            realizedReturnType = testType;
        } else {
            return ResultOrProblems.failed((Problem[])new Problem[]{TypeProblems.get().mismatch(functionCall.getArguments().get(0), elseType, testType)});
        }
        return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)this, givenTypes, (Type)realizedReturnType, args -> {
            Object test = args.get(0);
            if (test == null) {
                return args.get(1);
            }
            return test;
        }, (AutoCloseable[])new AutoCloseable[0]));
    }
}

