/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.lang;

import java.util.ArrayList;
import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.EmptyList;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.ancestor.AncestorType;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.util.ListUtils;

public class ConcatList
extends BaseRealizableFunction {
    public ConcatList() {
        super(ArgumentList.create((String)"lhs", (Type)Nullable.of((Type)RSList.LIST_ANYTHING), (String)"rhs", (Type)Nullable.of((Type)RSList.LIST_ANYTHING)), (Type)RSList.LIST_ANYTHING);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        if (givenTypes.size() != this.arguments.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(this.arguments.size(), givenTypes.size())});
        }
        return ProblemException.catching(() -> {
            Type lhsType = Nullable.strip((Type)((Type)givenTypes.get(0)));
            Type rhsType = Nullable.strip((Type)((Type)givenTypes.get(1)));
            if (lhsType == EmptyList.INSTANCE) {
                return this.emptyFunction(functionCall, givenTypes, 1);
            }
            if (rhsType == EmptyList.INSTANCE) {
                return this.emptyFunction(functionCall, givenTypes, 0);
            }
            RSList lhsListType = (RSList)Types.findOrThrow(functionCall.getArguments().get(0), (Type)RSList.LIST_ANYTHING, (Type)lhsType);
            RSList rhsListType = (RSList)Types.findOrThrow(functionCall.getArguments().get(1), (Type)RSList.LIST_ANYTHING, (Type)rhsType);
            AncestorType ancestorType = context.getTypeSet().computeAncestorType((Type)lhsListType, (Type)rhsListType).orElse(AncestorType.of((Type)RSList.create((Type)Nullable.ifTrue((lhsListType.getContainedType().isNullable() || rhsListType.getContainedType().isNullable() ? 1 : 0) != 0, (Type)Types.ANYTHING))));
            return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)ancestorType.getType(), args -> {
                List lhs = (List)ancestorType.getConvert().apply(args.get(0));
                List rhs = (List)ancestorType.getConvert().apply(args.get(1));
                if (lhs == null && rhs == null) {
                    return new ArrayList();
                }
                if (rhs == null || lhs == null) {
                    return new ArrayList(lhs == null ? rhs : lhs);
                }
                return ListUtils.concat((List)lhs, (List)rhs);
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    private RiskscapeFunction emptyFunction(FunctionCall functionCall, final List<Type> givenTypes, final int constantIndex) throws ProblemException {
        final RSList listType = (RSList)Types.findOrThrow(functionCall.getArguments().get(constantIndex), (Type)RSList.LIST_ANYTHING, (Type)givenTypes.get(constantIndex));
        return new RiskscapeFunction(){

            public Type getReturnType() {
                return listType;
            }

            public List<Type> getArgumentTypes() {
                return givenTypes;
            }

            public Object call(List<Object> args) {
                return args.get(constantIndex);
            }
        };
    }
}

