/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.lang;

import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.ScopedLambdaType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class Call
extends BaseRealizableFunction {
    public Call() {
        super(ArgumentList.create((String)"scope", (Type)Struct.EMPTY_STRUCT, (String)"lambda", (Type)LambdaType.NO_ARGS), (Type)Types.ANYTHING);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        if (this.arguments.size() != givenTypes.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{((ArgsProblems)Problems.get(ArgsProblems.class)).wrongNumber(this.arguments.size(), givenTypes.size())});
        }
        Struct inputType = givenTypes.get(0).asStruct();
        ScopedLambdaType lambdaType = givenTypes.get(1).find(ScopedLambdaType.class).orElse(null);
        if (lambdaType == null) {
            return ResultOrProblems.failed((Problem[])new Problem[]{((TypeProblems)Problems.get(TypeProblems.class)).mismatch(functionCall.getArguments().get(1), this.arguments.get(1).getType(), givenTypes.get(1))});
        }
        if (lambdaType.getArity() != 0) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ExpressionProblems.get().lambdaArityError(((FunctionCall.Argument)functionCall.getArguments().get(1)).getExpression(), lambdaType.getArity(), 0)});
        }
        Lambda lambda = (Lambda)((FunctionCall.Argument)functionCall.getArguments().get(1)).getExpression();
        ResultOrProblems realizedOr = context.getExpressionRealizer().realize((Type)inputType, lambda.getExpression());
        if (realizedOr.hasErrors()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ExpressionProblems.get().failedToRealize(lambda.getExpression(), (Type)inputType).withChildren(realizedOr.getProblems())});
        }
        RealizedExpression realizedLambda = (RealizedExpression)realizedOr.get();
        return ResultOrProblems.of((Object)RiskscapeFunction.create((Object)this, givenTypes, (Type)realizedLambda.getResultType(), args -> {
            Object arg = args.get(0);
            if (arg instanceof Tuple) {
                return realizedLambda.evaluate(arg);
            }
            return realizedLambda.evaluate((Object)Tuple.ofValues((Struct)inputType, (Object[])new Object[]{arg}));
        }, (AutoCloseable[])new AutoCloseable[0]));
    }
}

