/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.lang;

import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.bind.ParameterField;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.FunctionCallOptions;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;

public class AssertNotNull
extends BaseRealizableFunction {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public AssertNotNull() {
        super(ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("value", (Type)Nullable.ANYTHING), FunctionCallOptions.options(Options.class)}), (Type)Types.ANYTHING);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        return ProblemException.catching(() -> {
            if (givenTypes.size() < 1 || givenTypes.size() > this.arguments.size()) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumberRange(1, this.arguments.size(), givenTypes.size()));
            }
            Type itemType = Nullable.strip((Type)((Type)givenTypes.get(0)));
            Options options = (Options)FunctionCallOptions.bindOptions(Options.class, (RealizationContext)context, (ArgumentList)this.arguments, (FunctionCall)functionCall).getOrThrow();
            return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)itemType, args -> {
                Object item = args.get(0);
                if (item == null) {
                    String customMessage = options.message.orElse("");
                    if (customMessage.isBlank()) {
                        Expression itemExpression = ((FunctionCall.Argument)functionCall.getArguments().get(0)).getExpression();
                        int line = itemExpression.getBoundary().map(Pair::getLeft).map(t -> t.getLocation().getLine()).orElse(1);
                        throw new RiskscapeException((Problems)PROBLEMS.unexpectedNull(line, itemExpression));
                    }
                    throw new RiskscapeException((Problems)PROBLEMS.unexpectedNullCustomMessage(customMessage));
                }
                return item;
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    public static class Options {
        @ParameterField
        public Optional<String> message = Optional.empty();
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem unexpectedNull(int var1, Expression var2);

        public Problem unexpectedNullCustomMessage(String var1);
    }
}

