/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.lang;

import java.util.Arrays;
import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.EmptyList;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.ancestor.AncestorType;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.util.ListUtils;

public class AppendList
extends BaseRealizableFunction {
    public AppendList() {
        super(ArgumentList.create((String)"list", (Type)Nullable.of((Type)RSList.LIST_ANYTHING), (String)"element", (Type)Nullable.ANYTHING), (Type)RSList.LIST_ANYTHING);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        if (givenTypes.size() != this.arguments.size()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(this.arguments.size(), givenTypes.size())});
        }
        return ProblemException.catching(() -> {
            Type appendToType = Nullable.strip((Type)((Type)givenTypes.get(0)));
            Type elementType = (Type)givenTypes.get(1);
            if (appendToType == EmptyList.INSTANCE) {
                return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)RSList.create((Type)elementType), args -> {
                    Object element = args.get(1);
                    return Arrays.asList(element);
                }, (AutoCloseable[])new AutoCloseable[0]);
            }
            RSList listType = (RSList)Types.findOrThrow(functionCall.getArguments().get(0), (Type)RSList.LIST_ANYTHING, (Type)Nullable.strip((Type)((Type)givenTypes.get(0))));
            AncestorType ancestorType = context.getTypeSet().computeAncestorType(listType.getContainedType(), elementType).orElse(AncestorType.of((Type)Types.ANYTHING));
            RSList listReturnType = RSList.create((Type)ancestorType.getType());
            AncestorType listAncestorType = context.getTypeSet().computeAncestorType((Type)listType, (Type)listReturnType).orElse(AncestorType.of((Type)RSList.LIST_ANYTHING));
            return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)listReturnType, args -> {
                List list = (List)args.get(0);
                Object element = ancestorType.getConvert().apply(args.get(1));
                if (list == null) {
                    return Arrays.asList(element);
                }
                list = (List)listAncestorType.getConvert().apply((Object)list);
                return ListUtils.append((List)list, (Object)element);
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }
}

