/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.NoSuchMemberException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.coverage.IndexedTypedCoverage;
import nz.org.riskscape.engine.data.coverage.NearestNeighbourCoverage;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.ExpensiveResource;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.geo.IntersectionIndex;
import nz.org.riskscape.engine.geo.NearestNeighbourIndex;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.CoercionException;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.RSList;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.RelationType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.WithinSet;
import nz.org.riskscape.engine.util.SegmentedList;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.locationtech.jts.geom.Geometry;

public class ToTypedCoverage
extends BaseRealizableFunction
implements AggregationFunction {
    private static final String OPT_INDEX_CUT = "intersection_cut";
    private static final String OPT_INDEX_CUT_POINTS = "intersection_cut_points";
    private static final String OPT_INDEX_CUT_RATIO = "intersection_cut_ratio";
    private static final String OPT_INDEX_CUT_RATIO_POINTS = "intersection_cut_ratio_points";
    private static final String OPT_INDEX_CUT_SIZE = "intersection_cut_size";
    public static final Struct ALLOWED_OPTIONS = Struct.builder().add("index", (Type)new WithinSet((Type)Types.TEXT, new Object[]{"intersection", "nearest_neighbour"})).add("nearest_neighbour_max_distance", (Type)Types.FLOATING).add("intersection_cut", (Type)Types.BOOLEAN).add("intersection_cut_points", (Type)Types.INTEGER).add("intersection_cut_ratio", (Type)Types.FLOATING).add("intersection_cut_ratio_points", (Type)Types.INTEGER).add("intersection_cut_size", (Type)Types.INTEGER).build();

    public ToTypedCoverage() {
        super(ArgumentList.create((String)"values", (Type)RelationType.WILD, (String)"options", (Type)Types.ANYTHING), (Type)CoverageType.WILD);
    }

    @Override
    public RiskscapeFunction asFunction() {
        return AggregationFunction.addAggregationTo((AggregationFunction)this, (RiskscapeFunction)super.asFunction());
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall fc, List<Type> argumentTypes) {
        return ProblemException.catching(() -> {
            RealizationState rState = this.newRealizationState(context, fc);
            Type inputType = (Type)argumentTypes.get(0);
            rState.nullable = Nullable.is((Type)inputType);
            if (inputType.findAllowNull(CoverageType.class).isPresent()) {
                return RiskscapeFunction.create((Object)RiskscapeFunction.BUILT_IN, (List)argumentTypes, (Type)inputType, args -> args.get(0), (AutoCloseable[])new AutoCloseable[0]);
            }
            Object constant = this.arguments.evaluateConstant(context, fc, "values", Object.class, (Type)Types.ANYTHING).orElse(null);
            if (constant != null) {
                Object firstItem;
                List constantList;
                if (constant instanceof Relation) {
                    rState.memberType = ((Relation)constant).getType();
                } else if (constant instanceof List && !(constantList = (List)constant).isEmpty() && (firstItem = constantList.get(0)) instanceof Tuple) {
                    rState.memberType = ((Tuple)firstItem).getStruct();
                }
            } else {
                Type listMemberType = inputType.findAllowNull(RSList.class).map(RSList::getMemberType).orElse(null);
                if (listMemberType != null) {
                    rState.memberType = listMemberType.find(Struct.class).orElse(null);
                } else {
                    RelationType relationType = inputType.findAllowNull(RelationType.class).orElse(null);
                    if (relationType != null) {
                        rState.memberType = relationType.getMemberType();
                    }
                }
            }
            if (rState.memberType == null) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(0), (Type)inputType, Arrays.asList(RSList.create((Type)Struct.EMPTY_STRUCT), RelationType.WILD)));
            }
            this.validateMemberType(rState);
            CoverageBuilder coverageBuilder = this.coverageBuilder(rState);
            UntypedFunction function = constant != null ? this.constantFunction(context, argumentTypes, constant, coverageBuilder) : this.function(coverageBuilder);
            return RiskscapeFunction.create((Object)RiskscapeFunction.BUILT_IN, (List)argumentTypes, (Type)Nullable.ifTrue((boolean)rState.nullable, (Type)new CoverageType((Type)rState.memberType)), (UntypedFunction)function, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    public ResultOrProblems<RealizedAggregateExpression> realize(RealizationContext context, Type inputType, FunctionCall fc) {
        return ProblemException.catching(() -> {
            RealizationState rState = this.newRealizationState(context, fc);
            RealizedExpression itemExpression = (RealizedExpression)context.getExpressionRealizer().realize(inputType, ((FunctionCall.Argument)fc.getArguments().get(0)).getExpression()).getOrThrow(Problems.foundWith(fc.getArguments().get(0), (Problem[])new Problem[0]));
            rState.memberType = (Struct)itemExpression.getResultType().findAllowNull(Struct.class).orElseThrow(() -> new ProblemException((Problems)TypeProblems.get().notStruct(((FunctionCall.Argument)fc.getArguments().get(0)).getExpression(), itemExpression.getResultType())));
            this.validateMemberType(rState);
            CoverageBuilder coverageBuilder = this.coverageBuilder(rState);
            return RealizedAggregateExpression.create((Type)inputType, (Type)new CoverageType((Type)rState.memberType), (Expression)fc, () -> new CoverageProducingAccumulator(coverageBuilder, itemExpression, rState.geometryMember, rState.sridSet));
        });
    }

    private RealizationState newRealizationState(RealizationContext context, FunctionCall fc) throws ProblemException {
        if (fc.getArguments().size() < 1 || fc.getArguments().size() > this.arguments.size()) {
            throw new ProblemException((Problems)ArgsProblems.get().wrongNumberRange(1, this.arguments.size(), fc.getArguments().size()));
        }
        RealizationState input = new RealizationState();
        input.sridSet = context.getProject().getSridSet();
        input.options = this.parseAndValidateOptions(this.arguments.getArgument(fc, "options"), context);
        return input;
    }

    private void validateMemberType(RealizationState details) throws ProblemException {
        details.geometryMember = TupleUtils.findGeometryMember((Struct)details.memberType, (TupleUtils.FindOption)TupleUtils.FindOption.OPTIONAL);
        if (details.geometryMember == null) {
            throw new ProblemException((Problems)Problems.foundWith((Object)this.arguments.get(0), (Problems)TypeProblems.get().structMustHaveMemberType((Type)Types.GEOMETRY, details.memberType)));
        }
    }

    private UntypedFunction constantFunction(RealizationContext context, List<Type> argumentTypes, Object constant, CoverageBuilder builder) {
        ExpensiveResource<Object> lazilyBuilt = new ExpensiveResource<Object>(context.getProblemSink(), "build-index-", () -> this.function(builder).call(Arrays.asList(constant)));
        return args -> lazilyBuilt.get();
    }

    private UntypedFunction function(CoverageBuilder builder) {
        return args -> {
            Object values = args.get(0);
            if (values == null) {
                return values;
            }
            TupleIterator tupleIterator = values instanceof List ? ((List)values).iterator() : ((Relation)values).iterator();
            return builder.apply(tupleIterator);
        };
    }

    private CoverageBuilder coverageBuilder(RealizationState rState) {
        if ("nearest_neighbour".equals(rState.options.get("index"))) {
            double maxDistance = ((Number)rState.options.get("nearest_neighbour_max_distance")).doubleValue();
            return this.getNearestNeighbourBuilder(maxDistance, rState);
        }
        IntersectionIndex.Options options = IntersectionIndex.defaultOptions();
        options.setCutBeforeAdding(Optional.ofNullable(rState.options.getOrDefault(OPT_INDEX_CUT, null)));
        options.setCutRatio((Double)rState.options.getOrDefault(OPT_INDEX_CUT_RATIO, options.getCutRatio()));
        options.setCutPoints((Long)rState.options.getOrDefault(OPT_INDEX_CUT_POINTS, options.getCutPoints()));
        options.setCutRatioPoints((Long)rState.options.getOrDefault(OPT_INDEX_CUT_RATIO_POINTS, options.getCutRatioPoints()));
        options.setCutSizeMapUnits((Long)rState.options.getOrDefault(OPT_INDEX_CUT_SIZE, options.getCutSizeMapUnits()));
        return this.getIntersectionCoverageBuilder(rState, options);
    }

    private CoverageBuilder getIntersectionCoverageBuilder(final RealizationState rState, IntersectionIndex.Options options) {
        return tuples -> {
            final IntersectionIndex index = new IntersectionIndex(rState.geometryMember, rState.sridSet, options);
            CoordinateReferenceSystem crs = rState.nominateCrs((Iterator<Tuple>)tuples, index::insert);
            tuples.forEachRemaining(t -> index.insert((Tuple)t));
            index.build();
            return new IndexedTypedCoverage((Type)rState.memberType, rState.sridSet, crs){

                @Override
                protected Struct.StructMember getGeomMember() {
                    return rState.geometryMember;
                }

                @Override
                protected IntersectionIndex getIndex() {
                    return index;
                }
            };
        };
    }

    private CoverageBuilder getNearestNeighbourBuilder(double maxDistanceMetres, RealizationState rState) {
        return tuples -> {
            ArrayList sniffedTuple = new ArrayList(1);
            CoordinateReferenceSystem crs = rState.sniffCrsFromType().orElseGet(() -> rState.getFromTuples((Iterator<Tuple>)tuples, sniffedTuple::add));
            NearestNeighbourIndex index = NearestNeighbourIndex.metricMaxDistance(rState.geometryMember, rState.sridSet, crs, maxDistanceMetres);
            sniffedTuple.forEach(index::insert);
            tuples.forEachRemaining(t -> index.insert((Tuple)t));
            return new NearestNeighbourCoverage(() -> index, (Type)rState.memberType, crs, rState.sridSet);
        };
    }

    private Map<String, Object> parseAndValidateOptions(Optional<FunctionCall.Argument> optionsArg, RealizationContext context) throws ProblemException {
        if (!optionsArg.isPresent()) {
            return Collections.emptyMap();
        }
        Tuple options = (Tuple)optionsArg.get().evaluateConstant(context, Tuple.class, (Type)Struct.EMPTY_STRUCT).getOrThrow();
        try {
            options = Tuple.coerce((Struct)ALLOWED_OPTIONS, (Map)options.toMap(), EnumSet.of(Tuple.CoerceOptions.MISSING_IGNORED));
        }
        catch (NoSuchMemberException | CoercionException e) {
            throw new ProblemException((Problems)Problems.foundWith((Object)this.arguments.get(1), (Problems)Problems.caught((Throwable)e)));
        }
        if ("nearest_neighbour".equals(options.fetch("index")) && options.fetch("nearest_neighbour_max_distance") == null) {
            throw new ProblemException((Problems)Problems.foundWith((Object)this.arguments.get(1), (Problems)GeneralProblems.get().required((Object)"nearest_neighbour_max_distance")));
        }
        return options.toMap();
    }

    private static class RealizationState {
        SRIDSet sridSet;
        Map<String, Object> options;
        Struct memberType;
        boolean nullable;
        Struct.StructMember geometryMember;

        private RealizationState() {
        }

        Optional<CoordinateReferenceSystem> sniffCrsFromType() {
            return this.geometryMember.getType().findAllowNull(Referenced.class).map(Referenced::getCrs);
        }

        CoordinateReferenceSystem getFromTuples(Iterator<Tuple> tuples, Consumer<Tuple> consumer) {
            if (tuples.hasNext()) {
                Tuple firstTuple = tuples.next();
                consumer.accept(firstTuple);
                return this.sridSet.get((Geometry)firstTuple.fetch(this.geometryMember));
            }
            return DefaultEngineeringCRS.CARTESIAN_2D;
        }

        CoordinateReferenceSystem nominateCrs(Iterator<Tuple> tuples, Consumer<Tuple> consumer) {
            return this.sniffCrsFromType().orElseGet(() -> this.getFromTuples(tuples, consumer));
        }
    }

    private static interface CoverageBuilder
    extends Function<Iterator<Tuple>, TypedCoverage> {
    }

    private static class CoverageProducingAccumulator
    implements Accumulator {
        private final CoverageBuilder coverageBuilder;
        private final RealizedExpression valueExpression;
        private final Struct.StructMember geometryMember;
        private final SRIDSet sridSet;
        final List<Tuple> accumulated;

        CoverageProducingAccumulator(CoverageBuilder coverageBuilder, RealizedExpression valueExpression, Struct.StructMember geometryMember, SRIDSet sridSet) {
            this.coverageBuilder = coverageBuilder;
            this.valueExpression = valueExpression;
            this.geometryMember = geometryMember;
            this.sridSet = sridSet;
            this.accumulated = SegmentedList.forType((Type)Nullable.of((Type)valueExpression.getResultType()));
        }

        public Accumulator combine(Accumulator rhs) {
            if (rhs.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return rhs;
            }
            CoverageProducingAccumulator combined = new CoverageProducingAccumulator(this.coverageBuilder, this.valueExpression, this.geometryMember, this.sridSet);
            combined.accumulated.addAll(this.accumulated);
            combined.accumulated.addAll(((CoverageProducingAccumulator)rhs).accumulated);
            return combined;
        }

        public void accumulate(Object input) {
            Tuple toAccumulate = (Tuple)this.valueExpression.evaluate(input);
            if (toAccumulate == null) {
                return;
            }
            this.accumulated.add(toAccumulate);
        }

        public Object process() {
            return this.coverageBuilder.apply(this.accumulated.iterator());
        }

        public boolean isEmpty() {
            return this.accumulated.isEmpty();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CoverageProducingAccumulator)) {
                return false;
            }
            CoverageProducingAccumulator other = (CoverageProducingAccumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CoverageBuilder this$coverageBuilder = this.coverageBuilder;
            CoverageBuilder other$coverageBuilder = other.coverageBuilder;
            if (this$coverageBuilder == null ? other$coverageBuilder != null : !this$coverageBuilder.equals(other$coverageBuilder)) {
                return false;
            }
            RealizedExpression this$valueExpression = this.valueExpression;
            RealizedExpression other$valueExpression = other.valueExpression;
            if (this$valueExpression == null ? other$valueExpression != null : !this$valueExpression.equals(other$valueExpression)) {
                return false;
            }
            Struct.StructMember this$geometryMember = this.geometryMember;
            Struct.StructMember other$geometryMember = other.geometryMember;
            if (this$geometryMember == null ? other$geometryMember != null : !this$geometryMember.equals(other$geometryMember)) {
                return false;
            }
            SRIDSet this$sridSet = this.sridSet;
            SRIDSet other$sridSet = other.sridSet;
            if (this$sridSet == null ? other$sridSet != null : !this$sridSet.equals(other$sridSet)) {
                return false;
            }
            List<Tuple> this$accumulated = this.accumulated;
            List<Tuple> other$accumulated = other.accumulated;
            return !(this$accumulated == null ? other$accumulated != null : !((Object)this$accumulated).equals(other$accumulated));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CoverageProducingAccumulator;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CoverageBuilder $coverageBuilder = this.coverageBuilder;
            result = result * 59 + ($coverageBuilder == null ? 43 : $coverageBuilder.hashCode());
            RealizedExpression $valueExpression = this.valueExpression;
            result = result * 59 + ($valueExpression == null ? 43 : $valueExpression.hashCode());
            Struct.StructMember $geometryMember = this.geometryMember;
            result = result * 59 + ($geometryMember == null ? 43 : $geometryMember.hashCode());
            SRIDSet $sridSet = this.sridSet;
            result = result * 59 + ($sridSet == null ? 43 : $sridSet.hashCode());
            List<Tuple> $accumulated = this.accumulated;
            result = result * 59 + ($accumulated == null ? 43 : ((Object)$accumulated).hashCode());
            return result;
        }
    }
}

