/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.geometry;

import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Geometry;

public class Reproject
extends BaseRealizableFunction {
    public Reproject() {
        super(ArgumentList.create((String)"geom", (Type)Types.GEOMETRY, (String)"crs", (Type)Types.TEXT), (Type)Types.GEOMETRY);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argumentTypes) {
        return ProblemException.catching(() -> {
            if (argumentTypes.size() != this.arguments.size()) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(this.arguments.size(), argumentTypes.size()));
            }
            Type geometryArgType = (Type)argumentTypes.get(0);
            if (!context.getProject().getTypeSet().isAssignable(geometryArgType, (Type)Types.GEOMETRY)) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(0), (Type)geometryArgType));
            }
            geometryArgType = geometryArgType.findAllowNull(Referenced.class).map(Referenced::getUnderlyingType).orElse(geometryArgType);
            Type reprojectedType = null;
            UntypedFunction reprojectionFunction = null;
            SRIDSet sridSet = context.getProject().getSridSet();
            Type crsArgType = (Type)argumentTypes.get(1);
            Optional referencedCrsType = crsArgType.findAllowNull(Referenced.class);
            if (referencedCrsType.isPresent()) {
                CoordinateReferenceSystem targetCrs = ((Referenced)referencedCrsType.get()).getCrs();
                reprojectedType = Referenced.of((Type)geometryArgType, (CoordinateReferenceSystem)targetCrs);
                int targetSRID = sridSet.get(targetCrs);
                reprojectionFunction = args -> sridSet.reproject((Geometry)args.get(0), targetSRID);
            } else if (context.getProject().getTypeSet().isAssignable(crsArgType, (Type)Types.GEOMETRY)) {
                reprojectedType = geometryArgType;
                reprojectionFunction = args -> {
                    Geometry geom = (Geometry)args.get(0);
                    Geometry crs = (Geometry)args.get(1);
                    return sridSet.reproject(geom, crs.getSRID());
                };
            } else if (context.getProject().getTypeSet().isAssignable(crsArgType, (Type)Types.TEXT)) {
                BindingContext bindingContext = context.getProject().newBindingContext();
                ResultOrProblems crsString = this.arguments.getRequiredArgument(functionCall, "crs").flatMap(a -> a.evaluateConstant(context, String.class, (Type)Types.TEXT));
                if (crsString.isPresent()) {
                    CoordinateReferenceSystem targetCrs = (CoordinateReferenceSystem)bindingContext.bind(crsString.get(), CoordinateReferenceSystem.class).getOrThrow(Problems.foundWith(Parameter.class, (String)"crs", (Problem[])new Problem[0]));
                    reprojectedType = Referenced.of((Type)geometryArgType, (CoordinateReferenceSystem)targetCrs);
                    int targetSRID = sridSet.get(targetCrs);
                    reprojectionFunction = args -> sridSet.reproject((Geometry)args.get(0), targetSRID);
                } else {
                    reprojectedType = geometryArgType;
                    reprojectionFunction = args -> {
                        Geometry geom = (Geometry)args.get(0);
                        String crs = (String)args.get(1);
                        CoordinateReferenceSystem targetCrs = (CoordinateReferenceSystem)bindingContext.bind((Object)crs, CoordinateReferenceSystem.class).orElseThrow(problems -> new RiskscapeException((Problems)Problems.foundWith(Parameter.class, (String)"crs", (List)problems)));
                        int targetSRID = sridSet.get(targetCrs);
                        return sridSet.reproject(geom, targetSRID);
                    };
                }
            } else {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(1), (Type)((Type)argumentTypes.get(1))));
            }
            return RiskscapeFunction.create((Object)RiskscapeFunction.BUILT_IN, (List)argumentTypes, (Type)reprojectedType, (UntypedFunction)reprojectionFunction, (AutoCloseable[])new AutoCloseable[0]);
        });
    }
}

