/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.geometry;

import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeomFromWKT
extends BaseRealizableFunction {
    private final ArgumentList argumentsHidden = ArgumentList.create((String)"wkt_text", (Type)Types.TEXT, (String)"crs_name", (Type)Nullable.TEXT);

    public GeomFromWKT() {
        super(ArgumentList.create((String)"wkt_text", (Type)Types.TEXT), (Type)Types.GEOMETRY);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        return ProblemException.catching(() -> {
            WKTReader wktReader;
            if (givenTypes.size() == 1) {
                wktReader = new WKTReader();
            } else if (givenTypes.size() == 2) {
                CoordinateReferenceSystem crs = this.parseCrs(context, functionCall);
                wktReader = new WKTReader(context.getProject().getSridSet().getGeometryFactory(crs));
            } else {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(2, givenTypes.size()));
            }
            return new Instance(givenTypes, wktReader);
        });
    }

    private CoordinateReferenceSystem parseCrs(RealizationContext context, FunctionCall functionCall) throws ProblemException {
        String crsCode = (String)this.argumentsHidden.evaluateConstant(context, functionCall, "crs_name", String.class, (Type)Types.TEXT).getOrThrow();
        try {
            return CRS.decode((String)crsCode);
        }
        catch (NoSuchAuthorityCodeException e) {
            throw new ProblemException((Problems)GeometryProblems.get().unknownCrsCode(crsCode));
        }
        catch (FactoryException e) {
            throw new ProblemException((Problems)Problems.caught((Throwable)e));
        }
    }

    private static class Instance
    implements RiskscapeFunction {
        private final List<Type> argumentTypes;
        private final Type returnType = Types.GEOMETRY;
        private final WKTReader reader;

        public Object call(List<Object> args) {
            String wktText = (String)args.get(0);
            try {
                return this.reader.read(wktText);
            }
            catch (ParseException e) {
                throw new RiskscapeException((Problems)GeometryProblems.get().badWkt(wktText).withChildren(new Problems[]{Problems.caught((Throwable)e)}));
            }
        }

        @Generated
        public Instance(List<Type> argumentTypes, WKTReader reader) {
            this.argumentTypes = argumentTypes;
            this.reader = reader;
        }

        @Generated
        public List<Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        @Generated
        public Type getReturnType() {
            return this.returnType;
        }
    }
}

