/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.geometry;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.problem.GeneralProblems;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.types.WithinSet;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;

public class Buffer
extends BaseRealizableFunction {
    public static final List<String> ALLOWED_OPTIONS = Lists.newArrayList((Object[])new String[]{"cap", "vertex"});

    public Buffer() {
        super(ArgumentList.fromArray((FunctionArgument[])new FunctionArgument[]{new FunctionArgument("geom", (Type)Types.GEOMETRY), new FunctionArgument("distance", (Type)Types.FLOATING), new FunctionArgument("options", (Type)Struct.of((String)"cap", (Type)new WithinSet((Type)Types.TEXT, new Object[]{"flat", "round", "square"}), (String)"vertex", (Type)new WithinSet((Type)Types.TEXT, new Object[]{"bevel", "mitre", "round"})))}), (Type)Types.GEOMETRY);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall fc, List<Type> givenTypes) {
        return ProblemException.catching(() -> {
            Map options;
            Type geomType;
            if (givenTypes.size() < 2 || givenTypes.size() > this.arguments.size()) {
                throw new ProblemException((Problems)((ArgsProblems)Problems.get(ArgsProblems.class)).wrongNumberRange(2, this.arguments.size(), givenTypes.size()));
            }
            boolean nullableInputs = Nullable.is((Type)((Type)givenTypes.get(0)));
            Coercer geomCoercer = Coercer.identity((Type)Types.GEOMETRY);
            TypeSet typeSet = context.getProject().getTypeSet();
            if (!typeSet.isAssignable(geomType = Nullable.strip((Type)((Type)givenTypes.get(0))), (Type)Types.GEOMETRY)) {
                geomCoercer = (Coercer)typeSet.findEquivalenceCoercer(geomType, (Type)Types.GEOMETRY).orElseThrow(() -> new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(0), (Type)((Type)givenTypes.get(0)))));
                geomType = geomCoercer.getTargetType();
            }
            boolean bl = nullableInputs = nullableInputs || Nullable.is((Type)((Type)givenTypes.get(1)));
            if (!Nullable.strip((Type)((Type)givenTypes.get(1))).isNumeric()) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(1), (Type)((Type)givenTypes.get(1))));
            }
            Type bufferedReturnType = Nullable.ifTrue((boolean)nullableInputs, (Type)geomType.find(Referenced.class).map(ref -> Referenced.ofNullable((Type)Types.GEOMETRY, (CoordinateReferenceSystem)ref.getCrs())).orElse((Type)Types.GEOMETRY));
            if (givenTypes.size() == 3) {
                options = ((Tuple)this.arguments.evaluateConstant(context, fc, "options", Tuple.class, (Type)Struct.EMPTY_STRUCT).getOrThrow()).toMap();
                ArrayList optionKeys = Lists.newArrayList(options.keySet());
                optionKeys.removeAll(ALLOWED_OPTIONS);
                if (!optionKeys.isEmpty()) {
                    throw new ProblemException((Problems)GeneralProblems.get().notAnOption((String)optionKeys.get(0), (Object)"options", ALLOWED_OPTIONS));
                }
            } else {
                options = Collections.emptyMap();
            }
            BufferParameters bufferParams = new BufferParameters();
            this.updateParameters(bufferParams, options);
            return new BufferInstance(givenTypes, bufferedReturnType, geomCoercer, bufferParams, context.getProject().getSridSet());
        });
    }

    void updateParameters(BufferParameters parameters, Map<String, Object> options) throws ProblemException {
        Object vertex;
        Object cap = options.get("cap");
        if (cap != null) {
            if ("flat".equals(cap)) {
                parameters.setEndCapStyle(2);
            } else if ("round".equals(cap)) {
                parameters.setEndCapStyle(1);
            } else if ("square".equals(cap)) {
                parameters.setEndCapStyle(3);
            } else {
                throw new ProblemException((Problems)GeneralProblems.get().notAnOption(cap.toString(), (Object)"cap", (List)Lists.newArrayList((Object[])new String[]{"flat", "round", "square"})));
            }
        }
        if ((vertex = options.get("vertex")) != null) {
            if ("bevel".equals(vertex)) {
                parameters.setJoinStyle(3);
            } else if ("round".equals(vertex)) {
                parameters.setJoinStyle(1);
            } else if ("mitre".equals(vertex)) {
                parameters.setJoinStyle(2);
            } else {
                throw new ProblemException((Problems)GeneralProblems.get().notAnOption(vertex.toString(), (Object)"vertex", (List)Lists.newArrayList((Object[])new String[]{"bevel", "mitre", "round"})));
            }
        }
    }

    private static class BufferInstance
    implements RiskscapeFunction {
        private final List<Type> argumentTypes;
        private final Type returnType;
        private final Coercer geomCoercer;
        private final BufferParameters bufferParams;
        private final SRIDSet sridSet;

        public Object call(List<Object> args) {
            Object geomArg = args.get(0);
            if (geomArg == null) {
                return null;
            }
            Geometry geom = (Geometry)this.geomCoercer.apply(geomArg);
            Number distance = (Number)args.get(1);
            if (geom == null || distance == null) {
                return null;
            }
            double crsDistance = GeometryUtils.distanceToCrsUnits((double)distance.doubleValue(), (Geometry)geom, (SRIDSet)this.sridSet);
            return BufferOp.bufferOp((Geometry)geom, (double)crsDistance, (BufferParameters)this.bufferParams);
        }

        @Generated
        public BufferInstance(List<Type> argumentTypes, Type returnType, Coercer geomCoercer, BufferParameters bufferParams, SRIDSet sridSet) {
            this.argumentTypes = argumentTypes;
            this.returnType = returnType;
            this.geomCoercer = geomCoercer;
            this.bufferParams = bufferParams;
            this.sridSet = sridSet;
        }

        @Generated
        public List<Type> getArgumentTypes() {
            return this.argumentTypes;
        }

        @Generated
        public Type getReturnType() {
            return this.returnType;
        }
    }
}

