/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.geometry;

import java.util.List;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.RelationType;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;

public class Bounds
extends BaseRealizableFunction {
    public Bounds() {
        super(ArgumentList.create((String)"relation", (Type)RelationType.WILD), (Type)Types.GEOMETRY);
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> givenTypes) {
        return ProblemException.catching(() -> {
            SRIDSet sridSet = context.getProject().getSridSet();
            if (givenTypes.size() != 1) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(1, givenTypes.size()));
            }
            Type givenType = (Type)givenTypes.get(0);
            if (givenType.find(CoverageType.class).isPresent()) {
                return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)Types.POLYGON, args -> {
                    TypedCoverage coverage = (TypedCoverage)args.get(0);
                    return coverage.getEnvelope().map(bounds -> Bounds.toBoundsGeom((org.geotools.api.geometry.Bounds)bounds, coverage.getCoordinateReferenceSystem(), sridSet)).orElse(null);
                }, (AutoCloseable[])new AutoCloseable[0]);
            }
            if (!givenType.find(RelationType.class).isPresent()) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(0), (Type)givenType));
            }
            Referenced referencedType = (Referenced)givenType.find(Referenced.class).orElseThrow(() -> new ProblemException((Problems)GeometryProblems.get().notReferenced(givenType)));
            Type returnType = referencedType.wrapNullable((Type)Types.POLYGON);
            Object constant = this.arguments.get("relation").evaluateConstant(context, functionCall, Object.class).orElse(null);
            if (constant != null) {
                if (referencedType.getBounds() == null) {
                    Polygon bounds = Bounds.calculateBounds((Relation)constant, referencedType.getCrs(), sridSet);
                    return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)Nullable.of((Type)returnType), args -> bounds, (AutoCloseable[])new AutoCloseable[0]);
                }
                Polygon constantBounds = Bounds.toBoundsGeom((org.geotools.api.geometry.Bounds)referencedType.getBounds(), referencedType.getCrs(), sridSet);
                return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)returnType, args -> constantBounds, (AutoCloseable[])new AutoCloseable[0]);
            }
            return RiskscapeFunction.create((Object)this, (List)givenTypes, (Type)Nullable.of((Type)returnType), args -> {
                Relation relation = (Relation)args.get(0);
                return Bounds.calculateBounds(relation, referencedType.getCrs(), context.getProject().getSridSet());
            }, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    private static Polygon calculateBounds(Relation relation, CoordinateReferenceSystem crs, SRIDSet sridSet) {
        return relation.calculateBounds().map(envelope -> Bounds.toBoundsGeom((org.geotools.api.geometry.Bounds)envelope, crs, sridSet)).orElse(null);
    }

    private static Polygon toBoundsGeom(org.geotools.api.geometry.Bounds env, CoordinateReferenceSystem crs, SRIDSet sridSet) {
        GeometryFactory gf = sridSet.getGeometryFactory(crs);
        return gf.createPolygon(new Coordinate[]{new Coordinate(env.getMinimum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMaximum(1)), new Coordinate(env.getMaximum(0), env.getMinimum(1)), new Coordinate(env.getMinimum(0), env.getMinimum(1))});
    }
}

