/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function.benchmark;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.util.ArrayList;
import nz.org.riskscape.engine.RiskscapeException;
import org.apache.commons.math3.stat.descriptive.moment.Mean;

public class Timer {
    private static final int ONE_THOUSAND = 1000;
    private final String name;
    private int count;
    private Mean mean;
    private long start;
    private Duration total;
    private static final String STATS_FORMAT = "%s%n  Iterations      : %s%n  Round Time      : %s%n  Mean            : %s%n";

    public Timer(String name) {
        this.name = name;
        this.reset();
    }

    public void start() {
        if (this.start != 0L) {
            throw new RiskscapeException(String.format("Cannot start timer '%s', already running", this.name));
        }
        this.start = System.nanoTime();
    }

    public void stop() throws ArithmeticException {
        if (this.start == 0L) {
            throw new RiskscapeException(String.format("Cannot stop timer '%s', not running", this.name));
        }
        ++this.count;
        long duration = System.nanoTime() - this.start;
        this.total = this.total.plusNanos(duration);
        this.mean.increment((double)duration);
        this.start = 0L;
    }

    public final void reset() {
        this.count = 0;
        this.mean = new Mean();
        this.start = 0L;
        this.total = Duration.ZERO;
    }

    static String formatTime(double nanoTime) {
        int unit;
        double timeValue = nanoTime;
        ArrayList units = Lists.newArrayList((Object[])new String[]{"ns", "\u03bcs", "ms", "s"});
        for (unit = 0; timeValue >= 1000.0 && unit < units.size() - 1; timeValue /= 1000.0, ++unit) {
        }
        return String.format("%7.2f %s", timeValue, units.get(unit));
    }

    static String formatTime(Duration d) {
        if (d.getSeconds() > 0L) {
            float dSec = (float)d.getSeconds() + 1.0f * (float)d.getNano() / 1.0E9f;
            return String.format("%7.2f s", Float.valueOf(dSec));
        }
        return Timer.formatTime(d.getNano());
    }

    public String getStats() {
        if (this.count == 0) {
            return String.format("Timer '%s' has no measurements", this.name);
        }
        return String.format(STATS_FORMAT, this.name, this.count, Timer.formatTime(this.total), Timer.formatTime(this.mean.getResult()));
    }
}

