/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import lombok.NonNull;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import org.apache.commons.math3.analysis.function.Power;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;

public class Maths {
    private static final int THREE = 3;

    public static RiskscapeFunction newPolynomial(double[] coefficients) {
        PolynomialFunction internal = new PolynomialFunction(coefficients);
        return new FloatingFunction(x -> internal.value(x));
    }

    public static RiskscapeFunction newPolynomial(int numberOfCoefficients) {
        return new MathsFunction(numberOfCoefficients + 1, p -> {
            double[] doubles = new double[numberOfCoefficients];
            for (int i = 0; i < numberOfCoefficients; ++i) {
                doubles[i] = (Double)p.get(i);
            }
            return Maths.newPolynomial(doubles);
        });
    }

    public static RiskscapeFunction newPower(double degree) {
        Power internal = new Power(degree);
        return new FloatingFunction(x -> internal.value(x));
    }

    public static RiskscapeFunction newPower() {
        return new MathsFunction(2, p -> Maths.newPower((Double)p.get(0)));
    }

    public static RiskscapeFunction newCumulativeNormalDistribution(double mean, double stdDev) {
        NormalDistribution distrib = new NormalDistribution(mean, stdDev);
        return new FloatingFunction(x -> distrib.cumulativeProbability(x));
    }

    public static RiskscapeFunction newCumulativeNormalDistribution() {
        return new MathsFunction(3, p -> Maths.newCumulativeNormalDistribution((Double)p.get(0), (Double)p.get(1)));
    }

    public static RiskscapeFunction newCumulativeLogNormalDistribution(double scale, double shape) {
        LogNormalDistribution distrib = new LogNormalDistribution(scale, shape);
        return new FloatingFunction(x -> distrib.cumulativeProbability(x));
    }

    public static RiskscapeFunction newCumulativeLogNormalDistribution() {
        return new MathsFunction(3, p -> Maths.newCumulativeLogNormalDistribution((Double)p.get(0), (Double)p.get(1)));
    }

    public static RiskscapeFunction newConstant(final @NonNull Object constantValue) {
        if (constantValue == null) {
            throw new NullPointerException("constantValue is marked non-null but is null");
        }
        final Type riskscapeType = Types.fromJavaType(constantValue.getClass());
        return new RiskscapeFunction(){

            public Type getReturnType() {
                return riskscapeType;
            }

            public List<Type> getArgumentTypes() {
                return Collections.singletonList(riskscapeType);
            }

            public Object call(List<Object> args) {
                return constantValue;
            }
        };
    }

    public static class FloatingFunction
    implements RiskscapeFunction {
        private DoubleFunction<Double> internal;

        public FloatingFunction(DoubleFunction<Double> internal) {
            this.internal = internal;
        }

        public Object call(List<Object> args) {
            double xValue = (Double)Types.FLOATING.coerce(args.get(0));
            return this.internal.apply(xValue);
        }

        public List<Type> getArgumentTypes() {
            return Collections.singletonList(Types.FLOATING);
        }

        public Type getReturnType() {
            return Types.FLOATING;
        }
    }

    private static class MathsFunction
    implements RiskscapeFunction {
        private final Function<List<Double>, RiskscapeFunction> internal;
        private final List<Type> types;

        MathsFunction(int argCount, Function<List<Double>, RiskscapeFunction> internal) {
            this.internal = internal;
            this.types = new ArrayList<Type>(argCount);
            for (int i = 0; i < argCount; ++i) {
                this.types.add((Type)Types.FLOATING);
            }
        }

        public Object call(List<Object> args) {
            ArrayList<Double> doubles = new ArrayList<Double>();
            for (int i = 1; i < args.size(); ++i) {
                doubles.add((Double)Types.FLOATING.coerce(args.get(i)));
            }
            return this.internal.apply(doubles).call((List)Lists.newArrayList((Object[])new Object[]{args.get(0)}));
        }

        public List<Type> getArgumentTypes() {
            return this.types;
        }

        public Type getReturnType() {
            return Types.FLOATING;
        }
    }
}

