/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.GeometryProblems;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.BaseRealizableFunction;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.function.UntypedFunction;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.types.Geom;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.locationtech.jts.geom.Geometry;

public class GeometryPredicateFunction
extends BaseRealizableFunction {
    protected static final ArgumentList BASE_ARGUMENTS = ArgumentList.create((String)"lhs", (Type)Types.GEOMETRY, (String)"rhs", (Type)Types.GEOMETRY);
    private final BiPredicate<Geometry, Geometry> predicate;

    public GeometryPredicateFunction(BiPredicate<Geometry, Geometry> predicate) {
        super(BASE_ARGUMENTS, (Type)Types.BOOLEAN);
        this.predicate = predicate;
    }

    protected GeometryPredicateFunction(FunctionArgument ... extraArgs) {
        super(BASE_ARGUMENTS.withExtraArgument(extraArgs), (Type)Types.BOOLEAN);
        this.predicate = null;
    }

    @Override
    public ResultOrProblems<RiskscapeFunction> realize(RealizationContext context, FunctionCall functionCall, List<Type> argTypes) {
        return ProblemException.catching(() -> {
            if (this.arguments.size() != argTypes.size()) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(this.arguments.size(), argTypes.size()));
            }
            Function<List<Object>, BiPredicate<Geometry, Geometry>> predicateSupplier = this.realizePredicateSupplier(context, functionCall, argTypes);
            if (!((Type)argTypes.get(0)).find(Geom.class).isPresent()) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(0), (Type)((Type)argTypes.get(0))));
            }
            if (!((Type)argTypes.get(1)).find(Geom.class).isPresent()) {
                throw new ProblemException((Problems)ArgsProblems.mismatch((FunctionArgument)this.arguments.get(1), (Type)((Type)argTypes.get(1))));
            }
            Referenced lhsReferenced = ((Type)argTypes.get(0)).find(Referenced.class).orElse(null);
            Referenced rhsReferenced = ((Type)argTypes.get(1)).find(Referenced.class).orElse(null);
            SRIDSet sridSet = context.getProject().getSridSet();
            if (lhsReferenced != null && rhsReferenced != null && sridSet.requiresReprojection(lhsReferenced.getCrs(), rhsReferenced.getCrs())) {
                throw new ProblemException((Problems)GeometryProblems.get().mismatchedCrs(lhsReferenced.getCrs(), rhsReferenced.getCrs()));
            }
            UntypedFunction function = args -> {
                if (args.get(0) == null || args.get(1) == null) {
                    return null;
                }
                Geometry lhs = (Geometry)args.get(0);
                Geometry rhs = (Geometry)args.get(1);
                if (lhs.getSRID() != rhs.getSRID()) {
                    CoordinateReferenceSystem lhsCrs = lhs.getSRID() == 0 ? null : sridSet.get(lhs.getSRID());
                    CoordinateReferenceSystem rhsCrs = rhs.getSRID() == 0 ? null : sridSet.get(rhs.getSRID());
                    throw new RiskscapeException((Problems)GeometryProblems.get().mismatchedCrs(lhsCrs, rhsCrs));
                }
                BiPredicate predicateToUse = (BiPredicate)predicateSupplier.apply(args);
                return predicateToUse.test(lhs, rhs);
            };
            return RiskscapeFunction.create((Object)RiskscapeFunction.BUILT_IN, (List)argTypes, (Type)this.returnType, (UntypedFunction)function, (AutoCloseable[])new AutoCloseable[0]);
        });
    }

    protected Function<List<Object>, BiPredicate<Geometry, Geometry>> realizePredicateSupplier(RealizationContext context, FunctionCall functionCall, List<Type> argTypes) throws ProblemException {
        return args -> this.predicate;
    }

    @Generated
    public BiPredicate<Geometry, Geometry> getPredicate() {
        return this.predicate;
    }
}

