/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.dsl.Token;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.eqrule.Coercer;
import nz.org.riskscape.engine.typeset.TypeSet;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;

public class ExpressionAggregationFunction
implements AggregationFunction {
    private static final Lambda IDENTITY = (Lambda)ExpressionParser.parseString((String)"v -> v").isA(Lambda.class).get();
    private final Expression identityExpression;
    private final Lambda mapExpression;
    private final Lambda reduceExpression;
    private final Lambda processExpression;

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasIdentity() {
        return this.identityExpression != null;
    }

    public ResultOrProblems<RealizedAggregateExpression> realize(RealizationContext context, Type inputType, FunctionCall fc) {
        if (fc.getArguments().size() != 1) {
            return ResultOrProblems.failed((Problem[])new Problem[]{ArgsProblems.get().wrongNumber(1, fc.getArguments().size())});
        }
        return ProblemException.catching(() -> {
            Type resultType;
            Object identityValue;
            RealizedExpression valueExpressionR = (RealizedExpression)context.getExpressionRealizer().realize(inputType, ((FunctionCall.Argument)fc.getArguments().get(0)).getExpression()).getOrThrow(Problems.foundWith(fc.getArguments().get(0), (Problem[])new Problem[0]));
            Type valueType = valueExpressionR.getResultType();
            RiskscapeFunction mapFunction = this.toFunction(context, valueType, "map", this.mapExpression == null ? IDENTITY : this.mapExpression, valueType);
            Type mapType = mapFunction.getReturnType();
            RiskscapeFunction reduceFunction = this.toFunction(context, valueType, "reduce", this.reduceExpression, mapType, mapType);
            RiskscapeFunction processFunction = this.toFunction(context, valueType, "process", this.processExpression == null ? IDENTITY : this.processExpression, mapType);
            if (this.identityExpression != null) {
                Type processType;
                Type identityType;
                RealizedExpression identityRexpr = (RealizedExpression)context.getExpressionRealizer().realize((Type)Struct.EMPTY_STRUCT, this.identityExpression).getOrThrow(LocalProblems.get().couldNotRealizeExpression("identity", this.identityExpression));
                identityValue = identityRexpr.evaluate((Object)Tuple.EMPTY_TUPLE);
                TypeSet typeSet = context.getProject().getTypeSet();
                if (!typeSet.isAssignable(identityType = identityRexpr.getResultType(), processType = processFunction.getReturnType())) {
                    Coercer coercer = (Coercer)context.getProject().getTypeSet().findEquivalenceCoercer(identityType, processType).orElseThrow(() -> new ProblemException((Problems)LocalProblems.get().typeNotSupportedForThisFunction(valueType).withChildren(new Problems[]{Problems.foundWith((Object)this.identityExpression, (Problems)TypeProblems.get().couldNotCoerce(identityType, processType))})));
                    identityValue = coercer.apply(identityValue);
                }
                resultType = Nullable.strip((Type)processType);
            } else {
                resultType = processFunction.getReturnType();
                identityValue = null;
            }
            Object finalIdentityValue = identityValue;
            return RealizedAggregateExpression.create((Type)inputType, (Type)resultType, (Expression)fc, () -> new AccumInstance(valueExpressionR, mapFunction, reduceFunction, processFunction, finalIdentityValue));
        });
    }

    private RiskscapeFunction toFunction(RealizationContext context, Type inputType, String part, Lambda lambda, final Type ... argTypes) throws ProblemException {
        final Struct argsType = context.normalizeStruct(this.buildStruct(lambda, argTypes));
        final RealizedExpression realized = (RealizedExpression)context.getExpressionRealizer().realize((Type)argsType, lambda.getExpression()).getOrThrow(ps -> LocalProblems.get().typeNotSupportedForThisFunction(inputType).withChildren(new Problems[]{LocalProblems.get().couldNotRealizeExpression(part, (Expression)lambda).withChildren(new Problems[]{ps})}));
        return new RiskscapeFunction(){

            public Type getReturnType() {
                return realized.getResultType();
            }

            public List<Type> getArgumentTypes() {
                return Arrays.asList(argTypes);
            }

            public Object call(List<Object> args) {
                Tuple input = new Tuple(argsType);
                input.setAll(args);
                return realized.evaluate((Object)input);
            }
        };
    }

    private Struct buildStruct(Lambda lambda, Type ... argTypes) throws ProblemException {
        if (argTypes.length != lambda.getArguments().size()) {
            throw new ProblemException((Problems)ExpressionProblems.get().lambdaArityError((Expression)lambda, lambda.getArguments().size(), argTypes.length));
        }
        Struct struct = Struct.of();
        for (int i = 0; i < argTypes.length; ++i) {
            struct = struct.add(((Token)lambda.getArguments().get(i)).getValue(), argTypes[i]);
        }
        return struct;
    }

    public String toString() {
        return String.format("ExpressionAggregationFunction(identity=%s, map=%s, reduce=%s, process=%s)", this.identityExpression == null ? "None" : this.identityExpression.toSource(), this.mapExpression == null ? "None" : this.mapExpression.toSource(), this.reduceExpression == null ? "None" : this.reduceExpression.toSource(), this.processExpression == null ? "None" : this.processExpression.toSource());
    }

    @Generated
    public ExpressionAggregationFunction(Expression identityExpression, Lambda mapExpression, Lambda reduceExpression, Lambda processExpression) {
        this.identityExpression = identityExpression;
        this.mapExpression = mapExpression;
        this.reduceExpression = reduceExpression;
        this.processExpression = processExpression;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpressionAggregationFunction)) {
            return false;
        }
        ExpressionAggregationFunction other = (ExpressionAggregationFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Expression this$identityExpression = this.identityExpression;
        Expression other$identityExpression = other.identityExpression;
        if (this$identityExpression == null ? other$identityExpression != null : !this$identityExpression.equals(other$identityExpression)) {
            return false;
        }
        Lambda this$mapExpression = this.mapExpression;
        Lambda other$mapExpression = other.mapExpression;
        if (this$mapExpression == null ? other$mapExpression != null : !this$mapExpression.equals(other$mapExpression)) {
            return false;
        }
        Lambda this$reduceExpression = this.reduceExpression;
        Lambda other$reduceExpression = other.reduceExpression;
        if (this$reduceExpression == null ? other$reduceExpression != null : !this$reduceExpression.equals(other$reduceExpression)) {
            return false;
        }
        Lambda this$processExpression = this.processExpression;
        Lambda other$processExpression = other.processExpression;
        return !(this$processExpression == null ? other$processExpression != null : !this$processExpression.equals(other$processExpression));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ExpressionAggregationFunction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Expression $identityExpression = this.identityExpression;
        result = result * 59 + ($identityExpression == null ? 43 : $identityExpression.hashCode());
        Lambda $mapExpression = this.mapExpression;
        result = result * 59 + ($mapExpression == null ? 43 : $mapExpression.hashCode());
        Lambda $reduceExpression = this.reduceExpression;
        result = result * 59 + ($reduceExpression == null ? 43 : $reduceExpression.hashCode());
        Lambda $processExpression = this.processExpression;
        result = result * 59 + ($processExpression == null ? 43 : $processExpression.hashCode());
        return result;
    }

    public static class Builder {
        private Expression identityExpression;
        private Lambda mapExpression;
        private Lambda reduceExpression;
        private Lambda processExpression;

        public Builder map(String expr) {
            this.mapExpression = this.parseLambda(expr, "value");
            return this;
        }

        public Builder reduce(String expr) {
            this.reduceExpression = this.parseLambda(expr, "lhs", "rhs");
            return this;
        }

        public Builder process(String expr) {
            this.processExpression = this.parseLambda(expr, "value");
            return this;
        }

        public Builder identity(String expr) {
            this.identityExpression = ExpressionParser.parseString((String)expr);
            return this;
        }

        public ExpressionAggregationFunction build() {
            return new ExpressionAggregationFunction(this.identityExpression, this.mapExpression, this.reduceExpression, this.processExpression);
        }

        private Lambda parseLambda(String expr, String ... defaultArgs) {
            return ExpressionParser.parseString((String)expr).isA(Lambda.class).orElseGet(() -> (Lambda)ExpressionParser.parseString((String)(Arrays.asList(defaultArgs).stream().collect(Collectors.joining(", ")) + " -> " + expr)).isA(Lambda.class).get());
        }
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public static LocalProblems get() {
            return (LocalProblems)Problems.get(LocalProblems.class);
        }

        public Problem couldNotRealizeExpression(String var1, Expression var2);

        public Problem typeNotSupportedForThisFunction(Type var1);
    }

    private static class AccumInstance
    implements Accumulator {
        private final RealizedExpression valueExpression;
        private final RiskscapeFunction map;
        private final RiskscapeFunction reduce;
        private final RiskscapeFunction process;
        private final Object identity;
        private Object accumulated;
        private boolean empty;

        AccumInstance(RealizedExpression valueExpression, RiskscapeFunction map, RiskscapeFunction reduce, RiskscapeFunction process, Object identity) {
            this.valueExpression = valueExpression;
            this.map = map;
            this.reduce = reduce;
            this.process = process;
            this.identity = identity;
            this.empty = identity == null;
        }

        public Accumulator combine(Accumulator other) {
            AccumInstance rhs = (AccumInstance)other;
            if (rhs.accumulated == null) {
                return this;
            }
            if (this.accumulated == null) {
                return rhs;
            }
            AccumInstance cloned = new AccumInstance(this.valueExpression, this.map, this.reduce, this.process, rhs);
            cloned.accumulated = this.reduce.call(Arrays.asList(this.accumulated, rhs.accumulated));
            return cloned;
        }

        public void accumulate(Object input) {
            Object value = this.valueExpression.evaluate(input);
            this.empty = false;
            if (value == null) {
                return;
            }
            Object mapped = this.map.call(Arrays.asList(value));
            if (this.accumulated == null) {
                this.accumulated = mapped;
            } else if (mapped != null) {
                this.accumulated = this.reduce.call(Arrays.asList(this.accumulated, mapped));
            }
        }

        public Object process() {
            if (this.accumulated == null) {
                return this.identity;
            }
            Object processed = this.process.call(Arrays.asList(this.accumulated));
            if (processed == null) {
                return this.identity;
            }
            return processed;
        }

        @Generated
        public boolean isEmpty() {
            return this.empty;
        }
    }
}

