/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import lombok.Generated;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemSink;

public class ExpensiveResource<T>
implements Supplier<T> {
    private final ProblemSink logTo;
    private final String operationName;
    private final Supplier<T> supplier;
    private T built;

    private Thread startTimer() {
        long startTime = System.currentTimeMillis();
        long warnTimeMillis = 10000L;
        AtomicBoolean warned = new AtomicBoolean(false);
        Thread thread = new Thread(() -> {
            long nowMillis;
            while (!Thread.currentThread().isInterrupted()) {
                nowMillis = System.currentTimeMillis();
                if (nowMillis > startTime + warnTimeMillis) {
                    warned.set(true);
                    Problem problem = Problem.info((String)"%s running after %d seconds", (Object[])new Object[]{this.operationName, TimeUnit.SECONDS.convert(nowMillis - startTime, TimeUnit.MILLISECONDS)});
                    this.logTo.log(problem);
                }
                try {
                    Thread.sleep(warnTimeMillis);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (warned.get()) {
                nowMillis = System.currentTimeMillis();
                this.logTo.log(Problem.info((String)"%s finished in %d seconds", (Object[])new Object[]{this.operationName, TimeUnit.SECONDS.convert(nowMillis - startTime, TimeUnit.MILLISECONDS)}));
            }
        });
        thread.setDaemon(true);
        thread.setName("slow-op[" + this.operationName + "]");
        thread.start();
        return thread;
    }

    @Override
    public synchronized T get() {
        if (this.built == null) {
            Thread thread = this.startTimer();
            try {
                this.built = this.supplier.get();
            }
            finally {
                thread.interrupt();
            }
        }
        return this.built;
    }

    @Generated
    public ExpensiveResource(ProblemSink logTo, String operationName, Supplier<T> supplier) {
        this.logTo = logTo;
        this.operationName = operationName;
        this.supplier = supplier;
    }
}

