/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import nz.org.riskscape.engine.function.Maths;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;

public class DiscreteFunction
implements RiskscapeFunction {
    public static final List<Type> NUMERIC_TYPE_RANK = ImmutableList.of((Object)Types.INTEGER, (Object)Types.FLOATING, (Object)Types.DECIMAL);
    private final List<Pair> pairs;
    private final List<Type> argumentTypes;
    private final Type returnType;

    public static Builder builder() {
        return new Builder();
    }

    private DiscreteFunction(List<Pair> functions, Type argumentType, Type returnType) {
        this.pairs = functions;
        this.argumentTypes = Collections.singletonList(argumentType);
        this.returnType = returnType;
    }

    public Object call(@NonNull List<Object> args) {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (args.size() != 1) {
            throw new IllegalArgumentException(String.format("this function requires exactly 1 argument, %d given", args.size()));
        }
        Double arg = (Double)Types.FLOATING.coerce(args.get(0));
        for (Pair pair : this.pairs) {
            if (!pair.getRange().contains((Comparable)arg)) continue;
            RiskscapeFunction function = pair.getFunction();
            Object coercedArg = ((Type)function.getArgumentTypes().get(0)).coerce((Object)arg);
            Object rawReturned = function.call(Collections.singletonList(coercedArg));
            return this.getReturnType().coerce(rawReturned);
        }
        throw new IllegalArgumentException(String.format("%s is outside of the functions range - %s", args.get(0), this.pairs.stream().map(Pair::getRange).map(Range::toString).collect(Collectors.joining(", "))));
    }

    @Generated
    public List<Pair> getPairs() {
        return this.pairs;
    }

    @Generated
    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }

    public static class Builder {
        private List<Pair> soFar = new ArrayList<Pair>();
        private boolean linearInterpolation = false;
        private Type argumentType = Types.INTEGER;
        private Type returnType = Types.INTEGER;
        private boolean closeUpperBound = true;

        public DiscreteFunction build() {
            if (this.soFar.isEmpty()) {
                return new DiscreteFunction(this.soFar, this.argumentType, this.returnType);
            }
            if (this.linearInterpolation) {
                ArrayList<Pair> toAdd = new ArrayList<Pair>();
                this.fillGaps(toAdd);
                for (Pair gap : toAdd) {
                    this.add(gap);
                }
            }
            if (this.closeUpperBound) {
                this.closeDisconnectedUpperBounds();
            }
            return new DiscreteFunction(this.soFar, this.argumentType, this.returnType);
        }

        public Builder addFunction(double lower, double upper, RiskscapeFunction function) {
            return this.add((Range<Double>)Range.closedOpen((Comparable)Double.valueOf(lower), (Comparable)Double.valueOf(upper)), function);
        }

        public Builder addConstant(double lower, double upper, Number constant) {
            return this.add((Range<Double>)Range.closedOpen((Comparable)Double.valueOf(lower), (Comparable)Double.valueOf(upper)), Maths.newConstant(constant));
        }

        public Builder addPoint(double at, RiskscapeFunction function) {
            return this.add((Range<Double>)Range.singleton((Comparable)Double.valueOf(at)), function);
        }

        public Builder addPoint(double at, Number constant) {
            return this.add((Range<Double>)Range.singleton((Comparable)Double.valueOf(at)), Maths.newConstant(constant));
        }

        public Builder add(Range<Double> range, RiskscapeFunction function) {
            return this.add(new Pair(range, function));
        }

        public Builder add(Pair pair) {
            List args = pair.getFunction().getArgumentTypes();
            if (args.size() != 1) {
                throw new IllegalArgumentException(String.format("Functions must declare exactly 1 argument, not %d - %s", args.size(), pair));
            }
            this.returnType = this.highestRanking(this.returnType, pair.function.getReturnType());
            this.argumentType = this.highestRanking(this.argumentType, (Type)args.get(0));
            for (Pair checkAgainst : this.soFar) {
                Range intersection;
                if (!checkAgainst.range.isConnected(pair.range) || (intersection = checkAgainst.getRange().intersection(pair.range)).isEmpty()) continue;
                throw new IllegalArgumentException(String.format("Functions have overlapping ranges. %s overlaps %s", pair, checkAgainst));
            }
            this.soFar.add(pair);
            return this;
        }

        public Builder withoutUpperBoundClosing() {
            this.closeUpperBound = false;
            return this;
        }

        public Builder withLinearInterpolation() {
            this.linearInterpolation = true;
            return this;
        }

        private Type highestRanking(Type lhs, Type rhs) {
            if (NUMERIC_TYPE_RANK.indexOf(lhs) > NUMERIC_TYPE_RANK.indexOf(rhs)) {
                return lhs;
            }
            return rhs;
        }

        private void fillGaps(List<Pair> gapFills) {
            for (Pair lower : this.soFar) {
                if (!lower.range.hasUpperBound()) continue;
                Pair next = null;
                double lowersUpper = (Double)lower.range.upperEndpoint();
                double min = Double.MAX_VALUE;
                for (Pair pair : this.soFar) {
                    double pairsLower;
                    if (lower == pair || !pair.getRange().hasLowerBound() || !((pairsLower = ((Double)pair.range.lowerEndpoint()).doubleValue()) > lowersUpper) || !(pairsLower < min)) continue;
                    next = pair;
                    min = pairsLower;
                }
                if (next == null) continue;
                Range gap = Range.range((Comparable)Double.valueOf(lowersUpper), (BoundType)this.flip(lower.range.upperBoundType()), (Comparable)Double.valueOf(min), (BoundType)this.flip(next.range.lowerBoundType()));
                Double x1 = (Double)Types.FLOATING.coerce((Object)gap.lowerEndpoint());
                Double x2 = (Double)Types.FLOATING.coerce((Object)gap.upperEndpoint());
                Double y1 = (Double)Types.FLOATING.coerce(lower.function.call(Collections.singletonList(x1)));
                Double y2 = (Double)Types.FLOATING.coerce(next.function.call(Collections.singletonList(x2)));
                double slope = y2.equals(y1) ? 0.0 : (y2 - y1) / (x2 - x1);
                double c = y1 - slope * x1;
                gapFills.add(new Pair((Range<Double>)gap, Maths.newPolynomial(new double[]{c, slope})));
            }
        }

        private void closeDisconnectedUpperBounds() {
            ArrayList<Pair> toRemove = new ArrayList<Pair>();
            ArrayList<Pair> toAdd = new ArrayList<Pair>();
            for (Pair pair : this.soFar) {
                Range<Double> range = pair.range;
                if (!range.hasUpperBound() || range.upperBoundType() == BoundType.CLOSED) continue;
                Pair neighbour = null;
                for (Pair possibleNeighbour : this.soFar) {
                    if (!possibleNeighbour.range.hasLowerBound() || possibleNeighbour.range.lowerBoundType() == BoundType.OPEN || !((Double)possibleNeighbour.range.lowerEndpoint()).equals(range.upperEndpoint())) continue;
                    neighbour = possibleNeighbour;
                    break;
                }
                if (neighbour != null) continue;
                Range newRange = range.hasLowerBound() ? Range.range((Comparable)((Double)range.lowerEndpoint()), (BoundType)range.lowerBoundType(), (Comparable)((Double)range.upperEndpoint()), (BoundType)BoundType.CLOSED) : Range.upTo((Comparable)((Double)range.upperEndpoint()), (BoundType)BoundType.CLOSED);
                toRemove.add(pair);
                toAdd.add(new Pair((Range<Double>)newRange, pair.function));
            }
            for (Pair remove : toRemove) {
                this.soFar.remove(remove);
            }
            for (Pair add : toAdd) {
                this.add(add);
            }
        }

        private BoundType flip(BoundType boundType) {
            if (boundType == BoundType.CLOSED) {
                return BoundType.OPEN;
            }
            return BoundType.CLOSED;
        }
    }

    public static class Pair {
        private final Range<Double> range;
        private final RiskscapeFunction function;

        @Generated
        public Pair(Range<Double> range, RiskscapeFunction function) {
            this.range = range;
            this.function = function;
        }

        @Generated
        public Range<Double> getRange() {
            return this.range;
        }

        @Generated
        public RiskscapeFunction getFunction() {
            return this.function;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Range<Double> this$range = this.getRange();
            Range<Double> other$range = other.getRange();
            if (this$range == null ? other$range != null : !this$range.equals(other$range)) {
                return false;
            }
            RiskscapeFunction this$function = this.getFunction();
            RiskscapeFunction other$function = other.getFunction();
            return !(this$function == null ? other$function != null : !this$function.equals(other$function));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Range<Double> $range = this.getRange();
            result = result * 59 + ($range == null ? 43 : $range.hashCode());
            RiskscapeFunction $function = this.getFunction();
            result = result * 59 + ($function == null ? 43 : $function.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DiscreteFunction.Pair(range=" + String.valueOf(this.getRange()) + ", function=" + String.valueOf(this.getFunction()) + ")";
        }
    }
}

