/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import java.util.ArrayList;
import lombok.Generated;
import nz.org.riskscape.engine.ArgsProblems;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.engine.rl.RealizationContext;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.rl.agg.Accumulator;
import nz.org.riskscape.engine.rl.agg.AggregationFunction;
import nz.org.riskscape.engine.rl.agg.RealizedAggregateExpression;
import nz.org.riskscape.engine.types.LambdaType;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.Pair;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import nz.org.riskscape.rl.ast.FunctionCall;
import nz.org.riskscape.rl.ast.Lambda;
import nz.org.riskscape.rl.ast.StructDeclaration;

public class CompositeAggregationFunction
implements AggregationFunction {
    private Pair<StructDeclaration, Struct> getChildInputType(Expression childExpr, Type itemType) throws ProblemException {
        StructDeclaration childStructDecl = (StructDeclaration)childExpr.isA(StructDeclaration.class).orElseThrow(() -> new ProblemException((Problems)ExpressionProblems.get().mismatch(childExpr, StructDeclaration.class, "{mean: v -> mean(v.attr)}")));
        LambdaType type = null;
        ArrayList<StructDeclaration.Member> kludgedMembers = new ArrayList<StructDeclaration.Member>(childStructDecl.getMembers().size());
        for (StructDeclaration.Member member : childStructDecl.getMembers()) {
            Lambda lambda = (Lambda)member.getExpression().isA(Lambda.class).orElseThrow(() -> new ProblemException((Problems)ExpressionProblems.get().mismatch(member.getExpression(), Lambda.class, "v -> mean(v.attr)")));
            if (type == null) {
                type = LambdaType.create((Lambda)lambda);
                if (type.getArgs().size() != 1) {
                    throw new ProblemException((Problems)ExpressionProblems.get().lambdaArityError((Expression)lambda, type.getArgs().size(), 1));
                }
            } else {
                LambdaType newType = LambdaType.create((Lambda)lambda);
                if (!newType.getArgs().equals(type.getArgs())) {
                    throw new ProblemException((Problems)LocalProblems.get().lambdaArgsDiffer((String)newType.getArgs().get(0), (String)type.getArgs().get(0)));
                }
            }
            kludgedMembers.add(member.cloneWithExpression(lambda.getExpression()));
        }
        return Pair.of((Object)childStructDecl.withNewMembers(kludgedMembers, childStructDecl.getBoundary()), (Object)Struct.of((String)((String)type.getArgs().get(0)), (Type)itemType));
    }

    public ResultOrProblems<RealizedAggregateExpression> realize(RealizationContext context, final Type inputType, final FunctionCall fc) {
        return ProblemException.catching(() -> {
            if (fc.getArguments().size() != 2) {
                throw new ProblemException((Problems)ArgsProblems.get().wrongNumber(2, fc.getArguments().size()));
            }
            final RealizedExpression itemExpression = (RealizedExpression)context.getExpressionRealizer().realize(inputType, ((FunctionCall.Argument)fc.getArguments().get(0)).getExpression()).getOrThrow(Problems.foundWith(fc.getArguments().get(0), (Problem[])new Problem[0]));
            Expression childExpr = ((FunctionCall.Argument)fc.getArguments().get(1)).getExpression();
            final Pair<StructDeclaration, Struct> lambdaType = this.getChildInputType(childExpr, itemExpression.getResultType());
            final RealizedAggregateExpression childAgg = (RealizedAggregateExpression)context.getExpressionRealizer().realizeAggregate((Type)lambdaType.getRight(), (Expression)lambdaType.getLeft()).getOrThrow(Problems.foundWith(fc.getArguments().get(1), (Problem[])new Problem[0]));
            return new RealizedAggregateExpression(){

                public Accumulator newAccumulator() {
                    return new AccumInstance(itemExpression, (Struct)lambdaType.getRight(), childAgg.newAccumulator());
                }

                public Type getResultType() {
                    return childAgg.getResultType();
                }

                public Type getInputType() {
                    return inputType;
                }

                public Expression getExpression() {
                    return fc;
                }
            };
        }).composeProblems(Problems.foundWith((Object)fc, (Problem[])new Problem[0]));
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public static LocalProblems get() {
            return (LocalProblems)Problems.get(LocalProblems.class);
        }

        public Problem lambdaArgsDiffer(String var1, String var2);
    }

    private static class AccumInstance
    implements Accumulator {
        private final RealizedExpression valueExpression;
        private final Struct lambdaType;
        private final Accumulator child;

        public Accumulator combine(Accumulator other) {
            AccumInstance rhs = (AccumInstance)other;
            return new AccumInstance(this.valueExpression, this.lambdaType, this.child.combine(rhs.child));
        }

        public void accumulate(Object input) {
            Object toAccumulate = this.valueExpression.evaluate(input);
            if (toAccumulate == null) {
                return;
            }
            this.child.accumulate((Object)Tuple.ofValues((Struct)this.lambdaType, (Object[])new Object[]{toAccumulate}));
        }

        public Object process() {
            return this.child.process();
        }

        public boolean isEmpty() {
            return this.child.isEmpty();
        }

        @Generated
        public AccumInstance(RealizedExpression valueExpression, Struct lambdaType, Accumulator child) {
            this.valueExpression = valueExpression;
            this.lambdaType = lambdaType;
            this.child = child;
        }
    }
}

