/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.function;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.function.ArgumentList;
import nz.org.riskscape.engine.function.FunctionArgument;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.types.Type;

public abstract class BaseMathsFunction
implements IdentifiedFunction {
    private final String id = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, this.getClass().getSimpleName());
    protected String description = "";

    public String getDescription() {
        return this.description;
    }

    public Object call(List<Object> args) {
        throw new RuntimeException("not implemented");
    }

    public IdentifiedFunction.Category getCategory() {
        return IdentifiedFunction.Category.MATHS;
    }

    public URI getSourceURI() {
        return RiskscapeFunction.BUILT_IN;
    }

    protected RiskscapeFunction wrapping(Type ... newTypes) {
        ArgumentList prevArgs = this.getArguments();
        if (newTypes.length > prevArgs.size()) {
            throw new IllegalArgumentException("overloading should not declare new args");
        }
        ArrayList newArgs = Lists.newArrayList();
        for (int i = 0; i < newTypes.length; ++i) {
            newArgs.add(new FunctionArgument(prevArgs.get(i).getKeyword(), newTypes[i]));
        }
        return this.wrapping(new ArgumentList((List)newArgs));
    }

    protected RiskscapeFunction wrapping(FunctionArgument ... newArgs) {
        return this.wrapping(ArgumentList.fromArray((FunctionArgument[])newArgs));
    }

    protected RiskscapeFunction wrapping(final ArgumentList args) {
        final List argumentTypes = args.getArgumentTypes();
        return new RiskscapeFunction(){

            public Object call(List<Object> args2) {
                return BaseMathsFunction.this.call(args2);
            }

            public List<Type> getArgumentTypes() {
                return argumentTypes;
            }

            public ArgumentList getArguments() {
                return args;
            }

            public Type getReturnType() {
                return BaseMathsFunction.this.getReturnType();
            }
        };
    }

    @Generated
    public String getId() {
        return this.id;
    }
}

