/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.filter;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.UnknownFunctionException;
import nz.org.riskscape.engine.expr.ConstantExpression;
import nz.org.riskscape.engine.expr.RiskscapeFunctionExpression;
import nz.org.riskscape.engine.expr.StructAccessExpression;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.Maths;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.visitor.IsStaticExpressionVisitor;

public class FilterFactory
extends FilterFactoryImpl {
    public static final String ATTRIBUTE_SEPARATORS = "[/\\.]";
    private final java.util.function.Function<String, Optional<IdentifiedFunction>> functionFinder;

    public FilterFactory() {
        this.functionFinder = null;
    }

    public FilterFactory(java.util.function.Function<String, Optional<IdentifiedFunction>> riskscapeFunctionFinder) {
        this.functionFinder = riskscapeFunctionFinder;
    }

    public PropertyName property(Name name) {
        return this.property(name.getLocalPart());
    }

    public PropertyName path(String ... parts) {
        return new StructAccessExpression(parts);
    }

    public PropertyName property(String name) {
        String[] parts = name.split(ATTRIBUTE_SEPARATORS);
        return new StructAccessExpression(parts);
    }

    public Literal literal(double d) {
        return new ConstantExpression(d);
    }

    public Literal literal(float f) {
        return new ConstantExpression(Float.valueOf(f));
    }

    public Literal literal(long l) {
        return new ConstantExpression(l);
    }

    public Literal literal(int i) {
        return new ConstantExpression(i);
    }

    public Literal literal(Object obj) {
        return new ConstantExpression(obj);
    }

    public Function function(String name, Expression ... args) {
        RiskscapeFunctions fn = RiskscapeFunctions.get(name);
        if (fn != null) {
            List<Expression> argList = Arrays.asList(args);
            if (fn.minArgs == fn.maxArgs && argList.size() != fn.minArgs) {
                throw new RiskscapeException(String.format("%s requires %d arguments but only %d were supplied", fn.getFunctionName(), fn.maxArgs, argList.size()));
            }
            if (argList.size() < fn.minArgs) {
                throw new RiskscapeException(String.format("%s requires a minumun of %d arguments but %d were supplied", fn.getFunctionName(), fn.maxArgs, argList.size()));
            }
            if (argList.size() > fn.maxArgs) {
                throw new RiskscapeException(String.format("%s require a maximum of %d arguments but %d were supplied", fn.getFunctionName(), fn.maxArgs, argList.size()));
            }
            switch (fn) {
                case RSFUNC: {
                    return this.getRiskscapeFunction(argList);
                }
                case POWER: {
                    return this.getPowerFunction(argList);
                }
                case POLYNOMIAL: {
                    return this.getPolynomialFunction(argList);
                }
                case CUMULATIVE_NORMAL_DISTRIBUTION: {
                    return this.getCumulativeNormalDistributionFunction(argList);
                }
                case CUMULATIVE_LOG_NORMAL_DISTRIBUTION: {
                    return this.getCumulativeLogNormalDistributionFunction(argList);
                }
            }
        }
        return super.function(name, args);
    }

    RiskscapeFunctionExpression getRiskscapeFunction(List<Expression> args) {
        Expression functionNameExpression = args.get(0);
        if (!FilterFactory.isStatic(functionNameExpression)) {
            throw new RiskscapeException(RiskscapeFunctions.RSFUNC.getFunctionName() + " requires the first argument to be static");
        }
        String functionName = (String)functionNameExpression.evaluate(null, String.class);
        List<Expression> functionParameters = args.subList(1, args.size());
        return new RiskscapeFunctionExpression(functionName, () -> (RiskscapeFunction)this.functionFinder.apply(functionName).orElseThrow(() -> new UnknownFunctionException(functionName)), functionParameters);
    }

    private RiskscapeFunctionExpression getPowerFunction(List<Expression> args) {
        return new RiskscapeFunctionExpression(RiskscapeFunctions.POWER.getFunctionName(), () -> Maths.newPower(), args);
    }

    private RiskscapeFunctionExpression getPolynomialFunction(List<Expression> args) {
        return new RiskscapeFunctionExpression(RiskscapeFunctions.POLYNOMIAL.getFunctionName(), () -> Maths.newPolynomial(args.size() - 1), args);
    }

    private RiskscapeFunctionExpression getCumulativeNormalDistributionFunction(List<Expression> args) {
        return new RiskscapeFunctionExpression(RiskscapeFunctions.CUMULATIVE_NORMAL_DISTRIBUTION.getFunctionName(), () -> Maths.newCumulativeNormalDistribution(), args);
    }

    private RiskscapeFunctionExpression getCumulativeLogNormalDistributionFunction(List<Expression> args) {
        return new RiskscapeFunctionExpression(RiskscapeFunctions.CUMULATIVE_LOG_NORMAL_DISTRIBUTION.getFunctionName(), () -> Maths.newCumulativeLogNormalDistribution(), args);
    }

    public static boolean isStatic(Expression expression) {
        return (Boolean)expression.accept((ExpressionVisitor)IsStaticExpressionVisitor.VISITOR, null);
    }

    public static enum RiskscapeFunctions {
        POWER(2, 2),
        POLYNOMIAL(2, Integer.MAX_VALUE),
        CUMULATIVE_NORMAL_DISTRIBUTION(3, 3),
        CUMULATIVE_LOG_NORMAL_DISTRIBUTION(3, 3),
        RSFUNC(2, Integer.MAX_VALUE);

        final int minArgs;
        final int maxArgs;

        private RiskscapeFunctions(int minArgs, int maxArgs) {
            this.minArgs = minArgs;
            this.maxArgs = maxArgs;
        }

        public String getFunctionName() {
            return this.name().toLowerCase();
        }

        public static RiskscapeFunctions get(String name) {
            try {
                return RiskscapeFunctions.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
    }
}

