/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.filter;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.engine.expr.ConstantExpression;
import nz.org.riskscape.engine.expr.TypedExpression;
import nz.org.riskscape.engine.gt.FilterValidator;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;

public class FilterExpression
implements Function,
TypedExpression {
    private final Filter filter;

    public static FilterExpression of(Filter filter) {
        return new FilterExpression(filter);
    }

    @Override
    public ResultOrProblems<Type> evaluateType(Type sourceType) {
        return ResultOrProblems.of((Object)Types.BOOLEAN, FilterValidator.INSTANCE.validateFilter(sourceType.asStruct(), this.filter));
    }

    public Object evaluate(Object o) {
        return this.evaluate(o, Types.BOOLEAN.internalType());
    }

    public <T> T evaluate(Object o, Class<T> type) {
        Boolean raw = this.filter.evaluate(o);
        if (!type.isInstance(raw)) {
            return null;
        }
        return (T)raw;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public String getName() {
        return this.filter.toString();
    }

    public FunctionName getFunctionName() {
        return null;
    }

    public List<Expression> getParameters() {
        return Collections.emptyList();
    }

    public Literal getFallbackValue() {
        return new ConstantExpression(false);
    }

    @Generated
    private FilterExpression(Filter filter) {
        this.filter = filter;
    }

    @Generated
    public Filter getFilter() {
        return this.filter;
    }
}

