/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.expr;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.expr.TypedExpression;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ExpressionParser;
import nz.org.riskscape.rl.ast.Expression;
import nz.org.riskscape.rl.ast.ExpressionProblems;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Geometry;
import org.xml.sax.helpers.NamespaceSupport;

public class StructMemberAccessExpression
implements PropertyName,
TypedExpression {
    private final String propertyName;
    private final Struct.StructMember[] segments;
    private final boolean nullable;

    public static ResultOrProblems<StructMemberAccessExpression> build(Type sourceType, List<String> segments) {
        Struct first;
        Iterator<String> segmentsIter = segments.iterator();
        ArrayList<Struct.StructMember> memberList = new ArrayList<Struct.StructMember>(segments.size());
        boolean nullable = sourceType.isNullable();
        Type notNullSourceType = Nullable.strip((Type)sourceType);
        if (!(notNullSourceType instanceof Struct)) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Given type does not contain a struct - %s", (Object[])new Object[]{sourceType})});
        }
        Struct next = first = (Struct)notNullSourceType;
        while (segmentsIter.hasNext()) {
            String segment = segmentsIter.next();
            Struct.StructMember member = next.getEntry(segment);
            if (member == null) {
                return ResultOrProblems.failed((Problem[])new Problem[]{ExpressionProblems.get().noSuchStructMember(Joiner.on((char)'.').join(segments), Struct.flattenMemberKeys((Struct)first))});
            }
            memberList.add(member);
            Type unwrappedType = Nullable.strip((Type)member.getType()).getUnwrappedType();
            if (unwrappedType instanceof Struct) {
                next = (Struct)unwrappedType;
                nullable = nullable || member.getType().isNullable();
                continue;
            }
            if (!segmentsIter.hasNext()) continue;
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Property %s of %s is not a struct - was %s", (Object[])new Object[]{segment, next, member.getType()})});
        }
        return ResultOrProblems.of((Object)new StructMemberAccessExpression(nullable, memberList));
    }

    public StructMemberAccessExpression(boolean nullableResult, Struct.StructMember ... segmentsParam) {
        this(nullableResult, Arrays.asList(segmentsParam));
    }

    public StructMemberAccessExpression(boolean nullableResult, List<Struct.StructMember> segments) {
        this.segments = segments.toArray(new Struct.StructMember[segments.size()]);
        this.propertyName = segments.stream().map(s -> s.getKey()).collect(Collectors.joining("."));
        this.nullable = nullableResult;
    }

    public Struct getRootStruct() {
        return this.segments[0].getOwner();
    }

    @Override
    public ResultOrProblems<Type> evaluateType(Type sourceType) {
        if (Nullable.strip((Type)sourceType).getUnwrappedType() != this.getRootStruct()) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Given type must be the exact same computed type, but was not", (Object[])new Object[0])});
        }
        return ResultOrProblems.of((Object)this.getType());
    }

    public Type getType() {
        Type evaluated = this.segments[this.segments.length - 1].getType();
        return this.nullable ? Nullable.of((Type)evaluated) : evaluated;
    }

    public void setValue(Tuple object, Object toSet) {
        if (object.getStruct() != this.getRootStruct()) {
            throw new IllegalArgumentException("object is not of same struct " + String.valueOf(this.getRootStruct()));
        }
        Tuple next = object;
        for (int i = 0; i < this.segments.length - 1; ++i) {
            Struct.StructMember member = this.segments[i];
            if (next instanceof Tuple) {
                Tuple nextMap = next;
                if ((next = (Tuple)nextMap.fetch(member)) != null || !(member.getType().getUnwrappedType() instanceof Struct)) continue;
                Struct nextType = (Struct)member.getType().getUnwrappedType();
                next = new Tuple(nextType);
                nextMap.set(member, (Object)next);
                continue;
            }
            throw new IllegalArgumentException("Can not index non-tuple type " + String.valueOf(next.getClass()));
        }
        next.set(this.segments[this.segments.length - 1], toSet);
    }

    public Object evaluate(Object object) {
        if (object instanceof Tuple) {
            return this.evaluate((Tuple)object);
        }
        throw new IllegalArgumentException("this expression extracts properties from riskscape StructMap objects, can not work with " + String.valueOf(object));
    }

    private Object evaluate(Tuple map) {
        Object next = map;
        for (Struct.StructMember part : this.segments) {
            if (next instanceof Tuple) {
                Tuple nextMap = next;
                if ((next = nextMap.fetch(part)) != null) continue;
                return null;
            }
            throw new IllegalArgumentException("Can not index non-tuple type " + String.valueOf(next.getClass()));
        }
        return next;
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Object rawType = this.evaluate(object);
        if (context.isAssignableFrom(this.getType().internalType())) {
            return context.cast(rawType);
        }
        if (rawType instanceof Tuple && Geometry.class.isAssignableFrom(context)) {
            Tuple tuple = (Tuple)rawType;
            Struct.StructMember geometryMember = TupleUtils.findGeometryMember((Struct)tuple.getStruct(), (TupleUtils.FindOption)TupleUtils.FindOption.ONE_REQUIRED, () -> new ClassCastException("Can not find a single geometry member"));
            return context.cast(tuple.fetch(geometryMember));
        }
        Object converted = Converters.convert((Object)object, context);
        if (converted == null) {
            throw new ClassCastException(String.format("Unable to convert %s to %s", rawType, context));
        }
        return context.cast(converted);
    }

    public String toString() {
        return this.propertyName;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((PropertyName)this, extraData);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public List<Struct.StructMember> getSegments() {
        return ImmutableList.copyOf((Object[])this.segments);
    }

    public NamespaceSupport getNamespaceContext() {
        return null;
    }

    public Expression toExpression() {
        return ExpressionParser.parseString((String)this.getSegments().stream().map(Struct.StructMember::getKey).collect(Collectors.joining(".")));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructMemberAccessExpression)) {
            return false;
        }
        StructMemberAccessExpression other = (StructMemberAccessExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nullable != other.nullable) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        List<Struct.StructMember> this$segments = this.getSegments();
        List<Struct.StructMember> other$segments = other.getSegments();
        return !(this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StructMemberAccessExpression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nullable ? 79 : 97);
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        List<Struct.StructMember> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        return result;
    }
}

