/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.expr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.expr.StructMemberAccessExpression;
import nz.org.riskscape.engine.expr.TypedExpression;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.locationtech.jts.geom.Geometry;
import org.xml.sax.helpers.NamespaceSupport;

public class StructAccessExpression
implements PropertyName,
TypedExpression {
    public static final String SPLIT_ON = "\\.";
    public static final String SPLIT_ON_UNESCAPED = ".";
    private final String propertyName;
    private final List<String> segments;
    private StructMemberAccessExpression structAccess;

    public StructAccessExpression(String propertyName) {
        this.propertyName = propertyName;
        this.segments = Arrays.asList(propertyName.split(SPLIT_ON));
    }

    public StructAccessExpression(String ... segmentsParam) {
        this(Arrays.asList(segmentsParam));
    }

    public StructAccessExpression(List<String> segments) {
        this.segments = segments;
        this.propertyName = this.segments.stream().collect(Collectors.joining(SPLIT_ON_UNESCAPED));
    }

    public StructAccessExpression and(String additionalPath) {
        ArrayList<String> newSegments = new ArrayList<String>();
        this.segments.stream().forEach(s -> newSegments.add((String)s));
        newSegments.add(additionalPath);
        return new StructAccessExpression(Collections.unmodifiableList(newSegments));
    }

    @Override
    public ResultOrProblems<Type> evaluateType(Type sourceType) {
        return StructMemberAccessExpression.build(sourceType, this.segments).flatMap((expr, problems) -> expr.evaluateType(sourceType));
    }

    public Object evaluate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Tuple) {
            return this.evaluate((Tuple)object);
        }
        throw new IllegalArgumentException("this expression extracts properties from riskscape Tuple objects, can not work with " + String.valueOf(object));
    }

    private Object evaluate(Tuple map) {
        if (this.structAccess == null || map.getStruct() != this.structAccess.getRootStruct()) {
            this.structAccess = (StructMemberAccessExpression)StructMemberAccessExpression.build((Type)map.getStruct(), this.segments).get();
        }
        return this.structAccess.evaluate((Object)map);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        Object raw = this.evaluate(object);
        if (Geometry.class.isAssignableFrom(context) && raw instanceof Tuple) {
            Tuple fetched = (Tuple)raw;
            Struct.StructMember geometryMember = TupleUtils.findGeometryMember((Struct)fetched.getStruct(), (TupleUtils.FindOption)TupleUtils.FindOption.ONE_REQUIRED, () -> new IllegalArgumentException(String.format("Geometry requested, but tuple does not contain a geometry member: %s", fetched.getStruct())));
            return (T)fetched.fetch(geometryMember);
        }
        if (raw != null && !context.isInstance(raw)) {
            Type mappedType = Nullable.of((Type)((Type)Types.fromStrictJavaTypeOptional(context).orElseThrow(() -> new ClassCastException("Unsupported type for coercion - " + String.valueOf(context)))));
            return (T)mappedType.coerce(raw);
        }
        return (T)raw;
    }

    public String toString() {
        return this.propertyName;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((PropertyName)this, extraData);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public List<String> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public ResultOrProblems<StructMemberAccessExpression> getExpressionFor(Struct sourceType) {
        return StructMemberAccessExpression.build((Type)sourceType, this.segments);
    }

    public StructMemberAccessExpression getCachedExpression() {
        return this.structAccess;
    }

    void setCachedExpression(StructMemberAccessExpression ex) {
        this.structAccess = ex;
    }

    public NamespaceSupport getNamespaceContext() {
        return null;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StructAccessExpression)) {
            return false;
        }
        StructAccessExpression other = (StructAccessExpression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        List<String> this$segments = this.getSegments();
        List<String> other$segments = other.getSegments();
        if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
            return false;
        }
        StructMemberAccessExpression this$structAccess = this.structAccess;
        StructMemberAccessExpression other$structAccess = other.structAccess;
        return !(this$structAccess == null ? other$structAccess != null : !((Object)this$structAccess).equals(other$structAccess));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StructAccessExpression;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        List<String> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        StructMemberAccessExpression $structAccess = this.structAccess;
        result = result * 59 + ($structAccess == null ? 43 : ((Object)$structAccess).hashCode());
        return result;
    }
}

