/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.expr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import lombok.NonNull;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.engine.UnknownFunctionException;
import nz.org.riskscape.engine.expr.FunctionEvaluationException;
import nz.org.riskscape.engine.expr.TypedExpression;
import nz.org.riskscape.engine.function.FunctionCallException;
import nz.org.riskscape.engine.function.IdentifiedFunction;
import nz.org.riskscape.engine.function.RiskscapeFunction;
import nz.org.riskscape.engine.gt.FilterValidator;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;

@Deprecated
public class RiskscapeFunctionExpression
implements Function,
TypedExpression {
    private final Supplier<RiskscapeFunction> functionSupplier;
    private final String name;
    private List<? extends Expression> parameters;

    public RiskscapeFunctionExpression(@NonNull String name, @NonNull RiskscapeFunction vf, List<? extends Expression> params) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (vf == null) {
            throw new NullPointerException("vf is marked non-null but is null");
        }
        this.functionSupplier = () -> vf;
        this.name = name;
        this.parameters = params;
    }

    public RiskscapeFunctionExpression(@NonNull IdentifiedFunction vf, List<? extends Expression> params) {
        if (vf == null) {
            throw new NullPointerException("vf is marked non-null but is null");
        }
        this.functionSupplier = () -> vf;
        this.name = vf.getId();
        this.parameters = params;
    }

    public RiskscapeFunctionExpression(@NonNull String name, @NonNull Supplier<RiskscapeFunction> vf, List<? extends Expression> parameters) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (vf == null) {
            throw new NullPointerException("vf is marked non-null but is null");
        }
        this.functionSupplier = vf;
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("%s(%s)", this.name, this.parameters);
    }

    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public Object evaluate(Object scope) {
        RiskscapeFunction function = this.functionSupplier.get();
        if (function.getArgumentTypes().size() != this.parameters.size()) {
            throw new RiskscapeException(String.format("Function %s expects %d arguments but %d were given", this.name, function.getArgumentTypes().size(), this.parameters.size()));
        }
        ArrayList<Object> values = new ArrayList<Object>(this.parameters.size());
        for (int i = 0; i < this.parameters.size(); ++i) {
            Object coerced;
            Object paramValue;
            try {
                paramValue = this.parameters.get(i).evaluate(scope);
            }
            catch (RuntimeException e) {
                throw new FunctionEvaluationException("Failed to evaluate expression", e);
            }
            try {
                coerced = ((Type)function.getArgumentTypes().get(i)).coerce(paramValue);
            }
            catch (RuntimeException e) {
                throw new FunctionEvaluationException("Failed to coerce argument " + (i + 1), e);
            }
            values.add(coerced);
        }
        try {
            return function.call(values);
        }
        catch (Exception ex) {
            String message = String.format("Failed to invoke riskscape function %s against %s : %s", function, values, ex);
            throw new FunctionCallException(message, ex);
        }
    }

    @Override
    public ResultOrProblems<Type> evaluateType(Type sourceType) {
        try {
            RiskscapeFunction function = this.functionSupplier.get();
            if (function.getArgumentTypes().size() != this.parameters.size()) {
                return ResultOrProblems.failed((Problem[])new Problem[]{new Problem(Problem.Severity.ERROR, String.format("Function '%s' requires %d arguments but %d were provided", this.name, function.getArgumentTypes().size(), this.parameters.size()))});
            }
            ArrayList problems = new ArrayList();
            for (Expression expression : this.parameters) {
                problems.addAll(FilterValidator.INSTANCE.validateExpression(sourceType, expression).getProblems());
            }
            return ResultOrProblems.of((Object)function.getReturnType(), problems);
        }
        catch (UnknownFunctionException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{new Problem(Problem.Severity.ERROR, e.getMessage())});
        }
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Function)this, extraData);
    }

    public FunctionName getFunctionName() {
        return null;
    }

    public Literal getFallbackValue() {
        return null;
    }

    public <T> T evaluate(Object object, Class<T> context) {
        return (T)this.evaluate(object);
    }
}

