/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.relation;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.Parameter;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.BaseBookmarkResolver;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.BookmarkProblems;
import nz.org.riskscape.engine.data.coverage.GridTypedCoverage;
import nz.org.riskscape.engine.data.relation.AttributeMap;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.engine.function.ExpensiveResource;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.geo.GeometryValidation;
import nz.org.riskscape.engine.projection.ForceSridProjection;
import nz.org.riskscape.engine.projection.Projection;
import nz.org.riskscape.engine.projection.SetAttributeProjection;
import nz.org.riskscape.engine.projection.TypeProjection;
import nz.org.riskscape.engine.projection.ValidateGeometryProjection;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.raster.VectorToRaster;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.relation.TypeCheckingOptions;
import nz.org.riskscape.engine.restriction.ExpressionRestriction;
import nz.org.riskscape.engine.restriction.Restriction;
import nz.org.riskscape.engine.rl.ExpressionRealizer;
import nz.org.riskscape.engine.rl.RealizedExpression;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.TypeProblems;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemException;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationBookmarkResolver<T extends RelationBookmarkParams>
extends BaseBookmarkResolver<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RelationBookmarkResolver.class);
    private static final String RASTERIZE_KEY = "rasterize";
    private static final String RASTERIZE_EXPRESSION_KEY = "rasterize-expression";
    private static final String RASTERIZE_SCALE_KEY = "rasterize-scale-factor";
    private static final String RASTERIZE_GRID_SIZE_KEY = "rasterize-grid-size";
    protected VectorToRaster v2r = new VectorToRaster();

    public RelationBookmarkResolver(Engine engine) {
        super(engine);
    }

    protected Map<String, String> getAliasMapping() {
        return ImmutableMap.of((Object)"crs-force-xy", (Object)"crs-longitude-first");
    }

    protected ResultOrProblems build(T params) {
        ResultOrProblems relation = new ExpensiveResource<ResultOrProblems>(this.getEngine().getProblemSink(), ((Object)((Object)this)).getClass().getSimpleName(), () -> this.createRawRelationFromBookmark(params)).get();
        if (relation.hasErrors()) {
            return relation;
        }
        if (((RelationBookmarkParams)((Object)params)).skipInvalid) {
            relation = relation.map(r -> r.skipInvalid(this.engine.getProblemSink()));
        }
        Type type = ((RelationBookmarkParams)((Object)params)).type.orElse(null);
        if (((RelationBookmarkParams)((Object)params)).setAttribute.isPresent()) {
            Map setAttributeMap = (Map)((RelationBookmarkParams)((Object)params)).setAttribute.get();
            SetAttributeProjection projection = new SetAttributeProjection(setAttributeMap, params.getExpressionRealizer());
            relation = relation.flatMap(r -> r.project((Projection)projection)).composeProblems(Problem.error((String)"Could not apply all `set-attribute` parameters", (Object[])new Object[0]));
        } else if (type != null) {
            Map attributeMap = (Map)((RelationBookmarkParams)((Object)params)).mapAttribute.orElse(new AttributeMap());
            EnumSet<TypeCheckingOptions> options = EnumSet.of(TypeCheckingOptions.SKIP_INVALID_TUPLES, TypeCheckingOptions.COERCE);
            TypeProjection projection = new TypeProjection(type.asStruct(), attributeMap, options, params.getRealizationContext());
            relation = relation.flatMap(r -> r.project((Projection)projection));
        }
        if (((RelationBookmarkParams)((Object)params)).crs.isPresent()) {
            relation = relation.flatMap(r -> r.project((Projection)new ForceSridProjection(params.crs.get(), params.getProject().getSridSet())));
        }
        if (((RelationBookmarkParams)((Object)params)).filter.isPresent()) {
            relation = relation.flatMap(r -> this.applyFilter(params.filter.get(), (Relation)r, params));
        }
        boolean hasGeometry = (Boolean)relation.map(r -> TupleUtils.hasGeometryMember((Struct)r.getType())).orElse((Object)false);
        GeometryValidation geometryValidation = ((RelationBookmarkParams)((Object)params)).validateGeometry.orElse(params.getProject().getGeometryValidation());
        if (hasGeometry && geometryValidation != GeometryValidation.OFF) {
            relation = relation.flatMap(r -> r.project((Projection)new ValidateGeometryProjection(geometryValidation, params.bookmark, params.getProject().getProblemSink())));
        }
        if (((RelationBookmarkParams)((Object)params)).rasterize) {
            return relation.flatMap((r, p) -> this.rasterize(params, (Relation)r).withMoreProblems((Collection)p));
        }
        return relation;
    }

    protected ResultOrProblems<Relation> applyFilter(Expression filter, Relation relation, T params) {
        ExpressionRealizer expressionRealizer = params.getExpressionRealizer();
        return expressionRealizer.realize((Type)relation.getType(), filter).flatMap(fe -> {
            if (!Nullable.strip((Type)fe.getResultType()).equals(Types.BOOLEAN)) {
                return ResultOrProblems.failed((Problem[])new Problem[]{((TypeProblems)Problems.get(TypeProblems.class)).mismatch((Object)params.bookmark, (Type)Types.BOOLEAN, fe.getResultType())});
            }
            return relation.restrict((Restriction)new ExpressionRestriction(filter, expressionRealizer));
        }).composeProblems("Could not apply bookmark supplied filter `%s` to relation", new Object[]{filter.toSource()});
    }

    protected ResultOrProblems<TypedCoverage> rasterize(T params, Relation relation) {
        Expression coverageValueExpression = ((RelationBookmarkParams)((Object)params)).rasterizeExpression.get();
        return ProblemException.catching(() -> {
            RealizedExpression realizedCoverageExpr = (RealizedExpression)params.getExpressionRealizer().realize((Type)relation.getType(), coverageValueExpression).getOrThrow();
            if (!realizedCoverageExpr.getResultType().isNumeric()) {
                throw new ProblemException((Problems)Problem.error((String)"Expression '%s' does not result in a numeric type, was '%s'", (Object[])new Object[]{coverageValueExpression.toSource(), realizedCoverageExpr}));
            }
            Optional<CoordinateReferenceSystem> crs = relation.getSpatialMetadata().map(SpatialMetadata::getCrs);
            if (!crs.isPresent()) {
                throw new ProblemException((Problems)Problem.error((String)"Relation '%s' has no spatial metadata - can not convert to a raster", (Object[])new Object[]{relation}));
            }
            log.info("Calculating bounds from {} ...", (Object)relation);
            Optional bounds = relation.calculateBounds();
            if (!bounds.isPresent()) {
                throw new ProblemException((Problems)Problem.error((String)"Relation '%s' is either empty or has no spatial metadata - can not convert to a raster", (Object[])new Object[]{relation}));
            }
            double scaleFactor = params.rasterizeScaleFactor.orElseGet(() -> 1.0 / GeometryUtils.toCrsUnits((double)params.rasterizeGridSize.get(), (CoordinateReferenceSystem)((CoordinateReferenceSystem)crs.get())));
            GridCoverage2D coverage = this.v2r.convert(relation, realizedCoverageExpr, scaleFactor, (ReferencedEnvelope)bounds.get(), params.coverageTitle);
            return new GridTypedCoverage(coverage, params.getProject().getSridSet());
        });
    }

    protected void validateParameters(T params, BindingContext context) {
        if (!((RelationBookmarkParams)((Object)params)).type.isPresent() && ((RelationBookmarkParams)((Object)params)).mapAttribute.isPresent()) {
            ((RelationBookmarkParams)((Object)params)).problems.add(Problem.warning((String)"Attribute mappings were given, but no type specified.  These will be ignored", (Object[])new Object[0]));
        }
        if (((RelationBookmarkParams)((Object)params)).type.isPresent() && ((RelationBookmarkParams)((Object)params)).setAttribute.isPresent()) {
            params.add(((BookmarkProblems)Problems.get(BookmarkProblems.class)).setAttributesNotAllowedWithType());
        }
        ((RelationBookmarkParams)((Object)params)).crsName.ifPresent(name -> BaseBookmarkResolver.setCrs((BookmarkParameters)params, (String)name, (boolean)params.crsLongitudeFirst, (Parameter)this.getParameterSet().get("crs-name"), crs -> {
            params.crs = Optional.of(crs);
        }));
        boolean rasterizeErrors = ((RelationBookmarkParams)((Object)params)).problems.stream().anyMatch(problem -> problem.getAffected(Parameter.class).map(param -> param.getName().startsWith(RASTERIZE_KEY)).orElse(false));
        if (((RelationBookmarkParams)((Object)params)).rasterize && !rasterizeErrors) {
            boolean scaleFactorGiven;
            boolean gridSizeGiven = ((RelationBookmarkParams)((Object)params)).rasterizeGridSize.isPresent();
            if (gridSizeGiven == (scaleFactorGiven = ((RelationBookmarkParams)((Object)params)).rasterizeScaleFactor.isPresent())) {
                if (gridSizeGiven) {
                    params.add(Problem.error((String)"Only one of '%s' and '%s' can be specified", (Object[])new Object[]{RASTERIZE_GRID_SIZE_KEY, RASTERIZE_SCALE_KEY, RASTERIZE_KEY}));
                } else {
                    params.add(Problem.error((String)"'%s' or '%s' is required when '%s' is set to true", (Object[])new Object[]{RASTERIZE_SCALE_KEY, RASTERIZE_GRID_SIZE_KEY, RASTERIZE_KEY}));
                }
            } else if (gridSizeGiven) {
                double gridSizeValue = ((RelationBookmarkParams)((Object)params)).rasterizeGridSize.get();
                if (gridSizeValue <= 0.0) {
                    params.add(Problem.error((String)"Value of '%s' must be a non-zero positive number, was '%s'", (Object[])new Object[]{RASTERIZE_GRID_SIZE_KEY, gridSizeValue}));
                }
            } else {
                double scaleFactorValue = ((RelationBookmarkParams)((Object)params)).rasterizeScaleFactor.get();
                if (scaleFactorValue <= 0.0) {
                    params.add(Problem.error((String)"Value of '%s' must be a non-zero positive number, was '%s'", (Object[])new Object[]{RASTERIZE_SCALE_KEY, scaleFactorValue}));
                }
            }
            if (!((RelationBookmarkParams)((Object)params)).rasterizeExpression.isPresent()) {
                params.add(Problem.error((String)"'%s' is required when '%s' is set to true", (Object[])new Object[]{RASTERIZE_EXPRESSION_KEY, RASTERIZE_KEY}));
            }
        }
        ((RelationBookmarkParams)((Object)params)).coverageTitle = ((RelationBookmarkParams)((Object)params)).bookmark.getId();
    }

    protected abstract ResultOrProblems<Relation> createRawRelationFromBookmark(T var1);

    @Generated
    public VectorToRaster getV2r() {
        return this.v2r;
    }

    @Generated
    public void setV2r(VectorToRaster v2r) {
        this.v2r = v2r;
    }
}

