/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.relation;

import java.util.LinkedList;
import java.util.concurrent.Callable;
import lombok.Generated;
import nz.org.riskscape.engine.RiskscapeException;
import nz.org.riskscape.problem.Problems;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockDefeater {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LockDefeater.class);
    private final LinkedList<Task<?>> queue = new LinkedList();
    private boolean stopped;
    private final Thread thread = new Thread(null, () -> {
        while (true) {
            Task<?> task = null;
            LinkedList<Task<?>> linkedList = this.queue;
            synchronized (linkedList) {
                if (this.queue.isEmpty()) {
                    try {
                        this.queue.wait();
                    }
                    catch (InterruptedException e) {
                        if (this.stopped) {
                            log.info("Received stop, returning");
                            return;
                        }
                        log.error("Unexpected interrupt - {}", (Throwable)e);
                    }
                } else {
                    task = this.queue.removeFirst();
                }
            }
            if (task == null) continue;
            task.run();
        }
    });

    public LockDefeater(String name) {
        this.thread.setDaemon(true);
        this.thread.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(String taskName, Callable<T> callable) {
        if (!this.thread.isAlive()) {
            Thread thread = this.thread;
            synchronized (thread) {
                if (!this.thread.isAlive()) {
                    this.thread.start();
                    log.info("Started lock defeat thread {}", (Object)this.thread);
                }
            }
        }
        Task<T> task = new Task<T>(taskName, callable);
        LinkedList<Task<?>> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(task);
            this.queue.notify();
        }
        try {
            log.info("Waiting for task {} to complete", (Object)taskName);
            task.join();
            log.info("... task {} is complete", (Object)taskName);
            return task.result;
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Unexpected interrupt waiting for task to finish", e);
        }
    }

    public void stop() {
        if (!this.thread.isAlive()) {
            return;
        }
        log.info("Interrupting thread {}...", (Object)this.thread);
        this.stopped = true;
        this.thread.interrupt();
        try {
            log.info("Waiting for thread {} to stop...", (Object)this.thread);
            this.thread.join();
            log.info("...Done");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("unexpected interrupt", e);
        }
    }

    private static class Task<T> {
        private final String name;
        private final Callable<T> callable;
        private boolean done = false;
        private T result = null;
        public Exception error;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void join() throws InterruptedException {
            while (true) {
                Task task = this;
                synchronized (task) {
                    if (this.done) {
                        return;
                    }
                    if (this.error != null) {
                        throw new RiskscapeException((Problems)Problems.caught((Throwable)this.error));
                    }
                    this.wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            T t;
            try {
                t = this.callable.call();
            }
            catch (Exception e) {
                Task task = this;
                synchronized (task) {
                    this.error = e;
                    this.notify();
                    return;
                }
            }
            Task task = this;
            synchronized (task) {
                this.done = true;
                this.result = t;
                this.notify();
            }
        }

        @Generated
        public Task(String name, Callable<T> callable) {
            this.name = name;
            this.callable = callable;
        }
    }
}

