/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.relation;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import nz.org.riskscape.ReflectionUtils;
import nz.org.riskscape.engine.Engine;
import nz.org.riskscape.engine.FileProblems;
import nz.org.riskscape.engine.bind.JavaParameterSet;
import nz.org.riskscape.engine.data.BookmarkParameters;
import nz.org.riskscape.engine.data.BookmarkProblems;
import nz.org.riskscape.engine.data.relation.LockDefeater;
import nz.org.riskscape.engine.data.relation.RelationBookmarkParams;
import nz.org.riskscape.engine.data.relation.RelationBookmarkResolver;
import nz.org.riskscape.engine.relation.FeatureSourceRelation;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureSourceBookmarkResolver<DS extends DataStore, BP extends RelationBookmarkParams>
extends RelationBookmarkResolver<BP> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeatureSourceBookmarkResolver.class);
    public static final LockDefeater LOCK_DEFEATER = new LockDefeater("lock-defeater");
    public static final String DATA_LAYER = "layer";

    public FeatureSourceBookmarkResolver(Engine engine) {
        super(engine);
    }

    protected ResultOrProblems<Relation> wrapRelation(BP params, DS dataStore, FeatureSourceRelation relation, CoordinateReferenceSystem crs) {
        return ResultOrProblems.of((Object)((Object)relation));
    }

    @Override
    protected ResultOrProblems<Relation> createRawRelationFromBookmark(BP params) {
        DataStore dataStore;
        try {
            dataStore = LOCK_DEFEATER.call("create-datastore", () -> this.createDataStore(params));
        }
        catch (Exception e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problems.caught((Throwable)e)});
        }
        Problems problems = this.checkDataValid(params, dataStore);
        if (problems != null) {
            File file = this.getBookmarkedPath((BookmarkParameters)params).toFile();
            return ResultOrProblems.failed((Problem[])new Problem[]{FileProblems.get().geotoolsCannotRead(file).withChildren(new Problems[]{problems}), FileProblems.get().badGeospatialDataTip(file, this.getFormat(((RelationBookmarkParams)((Object)params)).bookmark))});
        }
        ResultOrProblems<SimpleFeatureSource> featureSource = this.createFeatureSource(params, dataStore);
        return featureSource.flatMap(sfs -> {
            CoordinateReferenceSystem crs = this.crsAtAllCosts(params, (SimpleFeatureSource)sfs);
            return this.wrapRelation(params, dataStore, new FeatureSourceRelation((SimpleFeatureSource)sfs, params.getProject().getSridSet(), crs), crs);
        });
    }

    public CoordinateReferenceSystem crsAtAllCosts(BP params, SimpleFeatureSource sfs) {
        if (((RelationBookmarkParams)((Object)params)).crs.isPresent()) {
            return ((RelationBookmarkParams)((Object)params)).crs.get();
        }
        CoordinateReferenceSystem crs = LOCK_DEFEATER.call("get-crs", () -> ((SimpleFeatureType)sfs.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem());
        if (crs == null) {
            crs = this.attemptPrjParse(params.getLocation());
        }
        if (crs == null) {
            log.warn("No crs could be parsed for feature source from {}, falling back to generic 2d", (Object)params.getLocation());
            crs = DefaultEngineeringCRS.GENERIC_2D;
        }
        return crs;
    }

    protected abstract DS createDataStore(BP var1) throws MalformedURLException, IOException;

    protected ResultOrProblems<SimpleFeatureSource> createFeatureSource(BP params, DS dataStore) {
        String layer = ((RelationBookmarkParams)((Object)params)).layer.orElse(null);
        try {
            List<Object> warnings;
            List<String> availableLayers = Arrays.asList(dataStore.getTypeNames());
            if (availableLayers.isEmpty()) {
                return ResultOrProblems.failed((Problem[])new Problem[]{BookmarkProblems.get().noFeatureLayers()});
            }
            if (Strings.isNullOrEmpty((String)layer)) {
                layer = availableLayers.get(0);
                warnings = availableLayers.size() > 1 ? Arrays.asList(Problem.warning((String)"DataStore '%s' contains multiple layers but no layer parameter given.  Selecting '%s'", (Object[])new Object[]{params.getLocation(), layer})) : Collections.emptyList();
            } else {
                warnings = Collections.emptyList();
            }
            if (!availableLayers.contains(layer)) {
                return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((String)"Requested layer '%s' does not exist.  Available: %s", (Object[])new Object[]{layer, availableLayers})});
            }
            String finalLayer = layer;
            return LOCK_DEFEATER.call("get-feature-source", () -> {
                try {
                    return ResultOrProblems.of((Object)dataStore.getFeatureSource(finalLayer), (List)warnings);
                }
                catch (IOException e) {
                    return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((Throwable)e, (String)"I/O Error accessing layer - %s", (Object[])new Object[]{e.getMessage()})});
                }
            });
        }
        catch (IOException e) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((Throwable)e, (String)"I/O Error accessing layer - %s", (Object[])new Object[]{e.getMessage()})});
        }
    }

    protected JavaParameterSet<BP> buildParameterSet() {
        return JavaParameterSet.fromBindingClass((Class)ReflectionUtils.findParameterClass(((Object)((Object)this)).getClass(), (int)1));
    }

    protected Problems checkDataValid(BP params, DS dataStore) {
        return null;
    }
}

