/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.relation;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nz.org.riskscape.engine.bind.BindingContext;
import nz.org.riskscape.engine.bind.TypeSafeBinder;
import nz.org.riskscape.engine.data.relation.AttributeMap;
import nz.org.riskscape.engine.problem.ProblemFactory;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.Problems;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.rl.ast.Expression;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AttributeMapBinder
extends TypeSafeBinder<Object, AttributeMap> {
    public static final LocalProblems PROBLEMS = (LocalProblems)Problems.get(LocalProblems.class);

    public AttributeMapBinder() {
        super(Object.class, AttributeMap.class);
    }

    public boolean canBind(Class<?> sourceType, Class<?> destinationType) {
        return super.canBind(sourceType, destinationType) && (sourceType.equals(String.class) || Map.class.isAssignableFrom(sourceType));
    }

    protected ResultOrProblems<AttributeMap> bindTypedValue(BindingContext context, Object value) {
        Map toBind;
        if (value instanceof String) {
            Object obj;
            try {
                obj = new JSONParser().parse(value.toString());
            }
            catch (ParseException e) {
                return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.couldNotParseJsonString(e.toString())});
            }
            if (!(obj instanceof Map)) {
                return ResultOrProblems.failed((Problem[])new Problem[]{PROBLEMS.jsonObjectNotADictionary(obj.getClass().getSimpleName())});
            }
            toBind = (Map)obj;
        } else if (value instanceof Map) {
            toBind = (Map)value;
        } else {
            throw new RuntimeException("api misuse - can't bind a " + String.valueOf(value.getClass()));
        }
        AttributeMap attrMap = new AttributeMap();
        LinkedList<Problem> collected = new LinkedList<Problem>();
        for (Map.Entry entry : toBind.entrySet()) {
            String key = entry.getKey().toString();
            ResultOrProblems expression = context.bind(entry.getValue(), Expression.class);
            if (expression.isPresent()) {
                attrMap.put((Object)key, (Object)((Expression)expression.get()));
                continue;
            }
            collected.add(Problems.foundWith((Object)key, (List)expression.getProblems()));
        }
        if (Problem.hasErrors(collected)) {
            return ResultOrProblems.failed(collected);
        }
        return ResultOrProblems.of((Object)attrMap, collected);
    }

    public static interface LocalProblems
    extends ProblemFactory {
        public Problem couldNotParseJsonString(String var1);

        public Problem jsonObjectNotADictionary(String var1);
    }
}

