/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.data.coverage.IndexedTypedCoverage;
import nz.org.riskscape.engine.function.ExpensiveResource;
import nz.org.riskscape.engine.geo.IntersectionIndex;
import nz.org.riskscape.engine.query.TupleUtils;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.relation.SpatialMetadata;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.problem.Problem;
import nz.org.riskscape.problem.ProblemCode;
import nz.org.riskscape.problem.ProblemSink;
import nz.org.riskscape.problem.ResultOrProblems;
import nz.org.riskscape.problem.StandardCodes;

public class SpatialRelationTypedCoverage
extends IndexedTypedCoverage {
    private final Relation backing;
    private final Struct.StructMember geomMember;
    private final ExpensiveResource<IntersectionIndex> indexResource;

    public static ResultOrProblems<SpatialRelationTypedCoverage> of(Relation relation, SRIDSet sridSet, ProblemSink logTo) {
        if (TupleUtils.findGeometryMember((Struct)relation.getType(), (TupleUtils.FindOption)TupleUtils.FindOption.OPTIONAL) == null) {
            return ResultOrProblems.failed((Problem[])new Problem[]{Problem.error((ProblemCode)StandardCodes.GEOMETRY_REQUIRED, (Object[])new Object[]{relation.getType()})});
        }
        SpatialRelationTypedCoverage coverage = new SpatialRelationTypedCoverage(relation, sridSet, logTo);
        return ResultOrProblems.of((Object)coverage);
    }

    private SpatialRelationTypedCoverage(Relation backing, SRIDSet sridSet, ProblemSink logTo) {
        super((Type)backing.getType(), sridSet, backing.getSpatialMetadata().map(smd -> smd.getCrs()).orElse(DEFAULT_CRS));
        this.backing = backing;
        if (backing.getSpatialMetadata().isPresent()) {
            SpatialMetadata sm = (SpatialMetadata)backing.getSpatialMetadata().get();
            this.geomMember = sm.getGeometryStructMember();
        } else {
            this.geomMember = TupleUtils.findRequiredGeometryMember((Struct)backing.getType());
        }
        this.indexResource = new ExpensiveResource<IntersectionIndex>(logTo, "coverage-index-" + backing.getSourceInformation(), () -> this.populateIndex());
    }

    @Override
    protected Struct.StructMember getGeomMember() {
        return this.geomMember;
    }

    @Override
    protected IntersectionIndex getIndex() {
        return this.indexResource.get();
    }

    private IntersectionIndex populateIndex() {
        IntersectionIndex index = IntersectionIndex.withDefaultOptions(this.geomMember, this.sridSet);
        try (TupleIterator it = this.backing.iterator();){
            while (it.hasNext()) {
                index.insert((Tuple)it.next());
            }
        }
        index.build();
        return index;
    }
}

