/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import java.util.Optional;
import java.util.function.Supplier;
import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.geo.NearestNeighbourIndex;
import nz.org.riskscape.engine.types.Type;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class NearestNeighbourCoverage
implements TypedCoverage {
    private NearestNeighbourIndex index;
    private final Supplier<NearestNeighbourIndex> indexSupplier;
    private final Type type;
    private final CoordinateReferenceSystem coordinateReferenceSystem;
    private final SRIDSet sridSet;

    public NearestNeighbourCoverage(Supplier<NearestNeighbourIndex> indexSupplier, Type type, CoordinateReferenceSystem coordinateReferenceSystem, SRIDSet sridSet) {
        this.indexSupplier = indexSupplier;
        this.type = type;
        this.coordinateReferenceSystem = coordinateReferenceSystem;
        this.sridSet = sridSet;
    }

    public Object evaluate(Point point) {
        Coordinate reprojected = this.sridSet.reproject((Geometry)point, this.sridSet.get(this.coordinateReferenceSystem)).getCoordinate();
        return this.getIndex().query(reprojected);
    }

    public Optional<ReferencedEnvelope> getEnvelope() {
        return Optional.of(new ReferencedEnvelope(this.getIndex().getEnvelope(), this.coordinateReferenceSystem));
    }

    public NearestNeighbourIndex getIndex() {
        if (this.index == null) {
            this.index = this.indexSupplier.get();
        }
        return this.index;
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }
}

