/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.geo.IntersectionIndex;
import nz.org.riskscape.engine.types.Nullable;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.util.Pair;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public abstract class IndexedTypedCoverage
implements TypedCoverage {
    protected final SRIDSet sridSet;
    protected final Type type;
    protected final CoordinateReferenceSystem coordinateReferenceSystem;

    protected IndexedTypedCoverage(Type type, SRIDSet sridSet, CoordinateReferenceSystem coordinateReferenceSystem) {
        this.type = Nullable.of((Type)type);
        this.sridSet = sridSet;
        this.coordinateReferenceSystem = coordinateReferenceSystem;
    }

    protected abstract Struct.StructMember getGeomMember();

    protected abstract IntersectionIndex getIndex();

    public Object evaluate(Point point) {
        IntersectionIndex index = this.getIndex();
        List<Tuple> intersections = index.findPointIntersections(point);
        return intersections.isEmpty() ? null : intersections.get(0);
    }

    public Optional<Function<Geometry, List<Pair<Geometry, Object>>>> getEvaluateIntersectionOp() {
        return Optional.of(geom -> this.evaluateIntersection((Geometry)geom));
    }

    List<Pair<Geometry, Object>> evaluateIntersection(Geometry geom) {
        List<Pair<Geometry, Object>> list = this.getIndex().findIntersections(geom);
        return list;
    }

    public Optional<ReferencedEnvelope> getEnvelope() {
        return Optional.of(this.getIndex().getReferencedEnvelope());
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.coordinateReferenceSystem;
    }
}

