/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.coverage.CoverageValueProviderHelper;
import nz.org.riskscape.engine.data.coverage.GridCoverageRelation;
import nz.org.riskscape.engine.geo.GeometryFamily;
import nz.org.riskscape.engine.geo.GeometryUtils;
import nz.org.riskscape.engine.grid.FeatureGrid;
import nz.org.riskscape.engine.grid.FeatureGridCell;
import nz.org.riskscape.engine.relation.Relation;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import nz.org.riskscape.engine.util.Pair;
import org.geotools.api.coverage.PointOutsideCoverageException;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class GridTypedCoverage
implements TypedCoverage {
    private final CoverageValueProviderHelper helper;
    private final GridCoverage2D coverage;
    private final NoDataContainer noData;
    private final SRIDSet sridSet;
    private final CRS.AxisOrder axisOrder;

    public GridTypedCoverage(GridCoverage2D coverage, SRIDSet sridSet) {
        this.helper = new CoverageValueProviderHelper(new ReferencedEnvelope(coverage.getEnvelope()), sridSet);
        this.coverage = coverage;
        this.noData = coverage instanceof GridCoverage2D ? CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage) : null;
        this.sridSet = sridSet;
        this.axisOrder = CRS.getAxisOrder((CoordinateReferenceSystem)this.getCoordinateReferenceSystem());
    }

    public Type getType() {
        return Types.FLOATING;
    }

    public Object evaluate(Point inputPoint) {
        try {
            double[] stored;
            Point point = (Point)this.helper.reprojectIfNecessary((Geometry)inputPoint);
            Position position = this.helper.pointToDirectPosition(point);
            if (!this.helper.contains(position)) {
                return null;
            }
            try {
                stored = this.coverage.evaluate(position, (double[])null);
            }
            catch (PointOutsideCoverageException ex) {
                return null;
            }
            double gridValue = stored[0];
            if (this.isNoData(gridValue)) {
                return null;
            }
            return stored[0];
        }
        catch (CoverageValueProviderHelper.EmptyGeometryException e) {
            return null;
        }
    }

    private boolean isNoData(double gridValue) {
        return this.noData != null && this.noData.getAsRange().contains(gridValue) || this.noData == null && Double.isNaN(gridValue);
    }

    public Optional<Function<Geometry, List<Pair<Geometry, Object>>>> getEvaluateIntersectionOp() {
        return Optional.of(geom -> this.evaluateIntersection((Geometry)geom));
    }

    public List<Pair<Geometry, Object>> evaluateIntersection(Geometry lookupGeom) {
        GeometryFamily expectedFamily = GeometryFamily.from((Geometry)lookupGeom);
        try {
            FeatureGrid featureGrid;
            int featureSrid = lookupGeom.getSRID();
            Geometry geom = this.helper.reprojectIfNecessary(lookupGeom);
            try {
                featureGrid = new FeatureGrid(geom, this.axisOrder, this.coverage.getGridGeometry());
            }
            catch (MismatchedDimensionException | TransformException e) {
                throw new RuntimeException(e);
            }
            int gridSrid = this.sridSet.get(featureGrid.getGridGeometry().getCoordinateReferenceSystem());
            LinkedList<Pair<Geometry, Object>> hits = new LinkedList<Pair<Geometry, Object>>();
            Iterator<FeatureGridCell> cellIterator = featureGrid.cellIterator();
            while (cellIterator.hasNext()) {
                Geometry geomCutByCell;
                double[] sampled;
                FeatureGridCell cell = cellIterator.next();
                try {
                    sampled = this.coverage.evaluate(cell.getGridPosition(), (double[])null);
                }
                catch (PointOutsideCoverageException e) {
                    continue;
                }
                if (this.isNoData(sampled[0]) || (geomCutByCell = GeometryUtils.removeNonFamilyMembers((Geometry)cell.computeIntersection(), (GeometryFamily)expectedFamily)).isEmpty()) continue;
                if (featureSrid != gridSrid) {
                    geomCutByCell.setSRID(gridSrid);
                    geomCutByCell = this.sridSet.reproject(geomCutByCell, featureSrid);
                }
                hits.add((Pair<Geometry, Object>)Pair.of((Object)geomCutByCell, (Object)sampled[0]));
            }
            return hits;
        }
        catch (CoverageValueProviderHelper.EmptyGeometryException e) {
            return Collections.emptyList();
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.getCoverage().getCoordinateReferenceSystem();
    }

    public String toString() {
        return String.format("%s[type=%s, coverage=%s]", this.getClass().getSimpleName(), this.getType(), this.coverage);
    }

    public Optional<ReferencedEnvelope> getEnvelope() {
        return Optional.of(this.helper.getEnvelope());
    }

    public Optional<Relation> asRelation() {
        if (this.coverage instanceof GridCoverage2D) {
            return Optional.of(GridCoverageRelation.create(this, this.coverage));
        }
        return super.asRelation();
    }

    @Generated
    public GridCoverage2D getCoverage() {
        return this.coverage;
    }

    @Generated
    public NoDataContainer getNoData() {
        return this.noData;
    }

    @Generated
    public SRIDSet getSridSet() {
        return this.sridSet;
    }
}

