/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.image.Raster;
import javax.media.jai.PlanarImage;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.Tuple;
import nz.org.riskscape.engine.data.coverage.GridTypedCoverage;
import nz.org.riskscape.engine.relation.BaseRelation;
import nz.org.riskscape.engine.relation.PeekingTupleIterator;
import nz.org.riskscape.engine.relation.TupleIterator;
import nz.org.riskscape.engine.types.CoverageType;
import nz.org.riskscape.engine.types.Referenced;
import nz.org.riskscape.engine.types.Struct;
import nz.org.riskscape.engine.types.Type;
import nz.org.riskscape.engine.types.Types;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;

public class GridCoverageRelation
extends BaseRelation {
    private final GridCoverage2D coverage;
    private final CoordinateReferenceSystem crs;
    private final SRIDSet sridSet;
    private NoDataContainer noData;

    public static Struct createStructType(CoverageType coverageType) {
        return Struct.of((String)"value", (Type)Types.FLOATING, (String)"geom", (Type)Types.GEOMETRY);
    }

    public static GridCoverageRelation create(GridTypedCoverage typedCoverage, GridCoverage2D coverage) {
        CoordinateReferenceSystem crs = coverage.getCoordinateReferenceSystem2D();
        ReferencedEnvelope envelope2d = coverage.getEnvelope2D();
        ReferencedEnvelope envelope = new ReferencedEnvelope((Envelope)envelope2d, crs);
        Struct struct = Struct.of((String)"value", (Type)Types.FLOATING, (String)"geom", (Type)Referenced.of((Type)Types.POLYGON, (CoordinateReferenceSystem)crs, (Envelope)envelope));
        return new GridCoverageRelation(typedCoverage.getSridSet(), coverage, struct);
    }

    protected GridCoverageRelation(SRIDSet sridSet, GridCoverage2D coverage, Struct type) {
        super(type);
        this.coverage = coverage;
        this.crs = coverage.getCoordinateReferenceSystem2D();
        this.sridSet = sridSet;
        this.noData = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
    }

    protected GridCoverageRelation(SRIDSet sridSet, GridCoverage2D coverage, BaseRelation.Fields fields) {
        super(fields);
        this.coverage = coverage;
        this.crs = coverage.getCoordinateReferenceSystem2D();
        this.sridSet = sridSet;
        this.noData = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
    }

    public String getSourceInformation() {
        return this.coverage.toString();
    }

    protected TupleIterator rawIterator() {
        return new IterImpl();
    }

    protected BaseRelation clone(BaseRelation.Fields fields) {
        return new GridCoverageRelation(this.sridSet, this.coverage, fields);
    }

    private class IterImpl
    extends PeekingTupleIterator {
        private final Struct struct;
        private final GeometryFactory gf;
        private long index;
        private int x;
        private int y;
        private final int pixelWidth;
        private final int pixelHeight;
        private final long totalPixels;
        MathTransform gridToCrsLowerLeft;
        MathTransform gridToCrsLowerRight;
        MathTransform gridToCrsUpperLeft;
        MathTransform gridToCrsUpperRight;
        private double noDataValue;
        private final PlanarImage image;
        double[] resultPtr;

        private IterImpl() {
            this.struct = GridCoverageRelation.this.getRawType();
            this.gf = GridCoverageRelation.this.sridSet.getGeometryFactory(GridCoverageRelation.this.crs);
            this.index = 0L;
            this.x = 0;
            this.y = 0;
            this.pixelWidth = GridCoverageRelation.this.coverage.getRenderedImage().getWidth();
            this.pixelHeight = GridCoverageRelation.this.coverage.getRenderedImage().getHeight();
            this.totalPixels = (long)this.pixelWidth * (long)this.pixelHeight;
            this.gridToCrsLowerLeft = GridCoverageRelation.this.coverage.getGridGeometry().getGridToCRS(PixelOrientation.LOWER_LEFT);
            this.gridToCrsLowerRight = GridCoverageRelation.this.coverage.getGridGeometry().getGridToCRS(PixelOrientation.LOWER_RIGHT);
            this.gridToCrsUpperLeft = GridCoverageRelation.this.coverage.getGridGeometry().getGridToCRS(PixelOrientation.UPPER_LEFT);
            this.gridToCrsUpperRight = GridCoverageRelation.this.coverage.getGridGeometry().getGridToCRS(PixelOrientation.UPPER_RIGHT);
            this.noDataValue = GridCoverageRelation.this.noData == null ? Double.NaN : GridCoverageRelation.this.noData.getAsSingleValue();
            this.image = (PlanarImage)GridCoverageRelation.this.coverage.getRenderedImage();
            this.resultPtr = new double[1];
        }

        public Tuple get() {
            while (this.index < this.totalPixels) {
                Position transformedUpperRight;
                Position transformedUpperLeft;
                Position transformedLowerRight;
                Position transformedLowerLeft;
                Position2D position = new Position2D((double)this.x, (double)this.y);
                try {
                    transformedLowerLeft = this.gridToCrsLowerLeft.transform((Position)position, null);
                    transformedLowerRight = this.gridToCrsLowerRight.transform((Position)position, null);
                    transformedUpperLeft = this.gridToCrsUpperLeft.transform((Position)position, null);
                    transformedUpperRight = this.gridToCrsUpperRight.transform((Position)position, null);
                }
                catch (MismatchedDimensionException | TransformException e) {
                    throw new RuntimeException(e);
                }
                int tileX = this.image.XToTileX(this.x);
                int tileY = this.image.YToTileY(this.y);
                Raster tile = this.image.getTile(tileX, tileY);
                if (tile == null) {
                    this.increment();
                    continue;
                }
                tile.getPixel(this.x, this.y, this.resultPtr);
                double result = this.resultPtr[0];
                this.increment();
                if (result == this.noDataValue || Double.isNaN(this.noDataValue) && Double.isNaN(result)) continue;
                Tuple tuple = Tuple.ofValues((Struct)this.struct, (Object[])new Object[]{this.resultPtr[0], this.gf.createPolygon(new Coordinate[]{new Coordinate(transformedLowerLeft.getOrdinate(0), transformedLowerLeft.getOrdinate(1)), new Coordinate(transformedLowerRight.getOrdinate(0), transformedLowerRight.getOrdinate(1)), new Coordinate(transformedUpperRight.getOrdinate(0), transformedUpperRight.getOrdinate(1)), new Coordinate(transformedUpperLeft.getOrdinate(0), transformedUpperLeft.getOrdinate(1)), new Coordinate(transformedLowerLeft.getOrdinate(0), transformedLowerLeft.getOrdinate(1))})});
                return tuple;
            }
            return null;
        }

        private void increment() {
            ++this.index;
            ++this.x;
            if (this.x >= this.pixelWidth) {
                this.x = 0;
                ++this.y;
            }
        }

        protected String getSource() {
            return GridCoverageRelation.this.coverage.toString();
        }
    }
}

