/*
 * Decompiled with CFR 0.152.
 */
package nz.org.riskscape.engine.data.coverage;

import java.util.Optional;
import nz.org.riskscape.engine.SRIDSet;
import nz.org.riskscape.engine.coverage.TypedCoverage;
import nz.org.riskscape.engine.data.coverage.CoverageValueProviderHelper;
import nz.org.riskscape.engine.data.coverage.Dataset2D;
import nz.org.riskscape.engine.types.Type;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;

public class DatasetCoverage
implements TypedCoverage {
    private final Dataset2D dataPoints;
    private final GridGeometry2D gridGeometry;
    private final Bounds sourceExtent;
    private final MathTransform crsToGrid;
    private final GridStartPoint dataStartsAt;
    private final CoverageValueProviderHelper helper;

    public DatasetCoverage(Bounds sourceExtent, Dataset2D dataPoints, GridStartPoint dataStartsAt, SRIDSet sridSet) {
        this.dataPoints = dataPoints;
        this.sourceExtent = sourceExtent;
        this.dataStartsAt = dataStartsAt;
        this.helper = new CoverageValueProviderHelper(new ReferencedEnvelope(sourceExtent), sridSet);
        this.gridGeometry = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, (int)dataPoints.getWidth(), (int)dataPoints.getHeight()), sourceExtent);
        this.crsToGrid = this.gridGeometry.getCRSToGrid2D();
    }

    public Type getType() {
        return this.dataPoints.getType();
    }

    private Position convertToGridPosition(Point point) {
        Position2D dest = new Position2D();
        try {
            this.crsToGrid.transform((Position)new Position2D(point.getX(), point.getY()), (Position)dest);
        }
        catch (TransformException e) {
            throw new RuntimeException(e);
        }
        return dest;
    }

    public Object evaluate(Point inputPoint) {
        try {
            Point point = (Point)this.helper.reprojectIfNecessary((Geometry)inputPoint);
            Position gridPosition = this.convertToGridPosition(point);
            long x = (long)gridPosition.getOrdinate(0);
            long y = (long)gridPosition.getOrdinate(1);
            if (this.dataPoints.isInBounds(x, y)) {
                return this.dataPoints.getValue(x, y);
            }
            return null;
        }
        catch (CoverageValueProviderHelper.EmptyGeometryException e) {
            return null;
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridGeometry.getCoordinateReferenceSystem();
    }

    public Optional<ReferencedEnvelope> getEnvelope() {
        return Optional.of(this.helper.getEnvelope());
    }

    public static enum GridStartPoint {
        NORTH_WEST_CORNER,
        NORTH_EAST_CORNER,
        SOUTH_EAST_CORNER,
        SOUTH_WEST_CORNER;

    }
}

